/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.GoToHashOrRefPopup;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JComponent;

public class GoToHashOrRefAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        VcsLogUtil.triggerUsage(e);
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsLogUiImpl logUi = (VcsLogUiImpl)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getVisibleRoots(logUi);
        GoToHashOrRefPopup popup = new GoToHashOrRefPopup(project2, logUi.getDataPack().getRefs(), visibleRoots, (Function<String, Future>)((Function)text -> log.jumpToReference(text)), (Function<VcsRef, Future>)((Function)vcsRef -> logUi.jumpToCommit(vcsRef.getCommitHash(), vcsRef.getRoot())), logUi.getColorManager(), new VcsGoToRefComparator(logUi.getDataPack().getLogProviders()));
        popup.show((JComponent)((Object)logUi.getTable()));
    }

    public void update(AnActionEvent e) {
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && log != null && logUi != null);
    }
}

