/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class VcsUserImpl
implements VcsUser {
    @NotNull
    private final String myName;
    @NotNull
    private final String myEmail;

    public VcsUserImpl(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsUserImpl", "<init>"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/impl/VcsUserImpl", "<init>"));
        }
        this.myName = name;
        this.myEmail = VcsUserUtil.emailToLowerCase(email);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getEmail() {
        String string = this.myEmail;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getEmail"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsUserImpl user = (VcsUserImpl)o;
        if (!this.myName.equals(user.myName)) {
            return false;
        }
        return this.myEmail.equals(user.myEmail);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myEmail);
    }

    public String toString() {
        return VcsUserUtil.toExactString(this);
    }
}

