/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ContentsUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    public static final String TAB_NAME = "Log";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer;

    public VcsLogContentProvider(@NotNull Project project2, @NotNull VcsProjectLog projectLog) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        if (projectLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLog", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        this.myContainer = new JBPanel((LayoutManager)new BorderLayout());
        this.myProject = project2;
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated() {
                VcsLogContentProvider.this.addLogUi();
            }

            @Override
            public void logDisposed() {
                VcsLogContentProvider.this.myContainer.removeAll();
                VcsLogContentProvider.this.closeLogTabs();
            }
        });
        if (this.myProjectLog.getLogManager() != null) {
            this.addLogUi();
        }
    }

    private void addLogUi() {
        this.myContainer.add((Component)this.myProjectLog.initMainLog(TAB_NAME), "Center");
    }

    @Override
    public JComponent initContent() {
        this.myProjectLog.createLog();
        return this.myContainer;
    }

    @Override
    public void disposeContent() {
        this.myContainer.removeAll();
        this.closeLogTabs();
    }

    public static void openAnotherLogTab(@NotNull VcsLogManager logManager, @NotNull Project project2) {
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentProvider", "openAnotherLogTab"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "openAnotherLogTab"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        VcsLogContentProvider.openLogTab(logManager, project2, VcsLogContentProvider.generateShortName(toolWindow), null);
    }

    public static VcsLogUiImpl openLogTab(@NotNull VcsLogManager logManager, @NotNull Project project2, @NotNull String shortName, @Nullable VcsLogFilter filter) {
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentProvider", "openLogTab"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "openLogTab"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/vcs/log/impl/VcsLogContentProvider", "openLogTab"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name = ContentUtilEx.getFullName(TAB_NAME, shortName);
        VcsLogUiImpl logUi = logManager.createLogUi(name, name, filter);
        ContentUtilEx.addTabbedContent(toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, logUi)), TAB_NAME, shortName, true, logUi);
        toolWindow.activate(null);
        logManager.scheduleInitialization();
        return logUi;
    }

    @NotNull
    private static String generateShortName(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/vcs/log/impl/VcsLogContentProvider", "generateShortName"));
        }
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(toolWindow.getContentManager(), TAB_NAME);
        if (tabbedContent != null) {
            String string = String.valueOf(tabbedContent.getTabs().size() + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider", "generateShortName"));
            }
            return string;
        }
        List contents = ContainerUtil.filter((Object[])toolWindow.getContentManager().getContents(), content -> TAB_NAME.equals(content.getUserData(Content.TAB_GROUP_NAME_KEY)));
        String string = String.valueOf(contents.size() + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider", "generateShortName"));
        }
        return string;
    }

    private void closeLogTabs() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.VCS);
        if (toolWindow != null) {
            for (Content content : toolWindow.getContentManager().getContents()) {
                if (!ContentUtilEx.isContentTab(content, TAB_NAME)) continue;
                ContentsUtil.closeContentTab((ContentManager)toolWindow.getContentManager(), (Content)content);
            }
        }
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project2) {
            Boolean bl = !VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project2).getAllVcsRoots()), project2).isEmpty();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate", "fun"));
            }
            return bl;
        }
    }
}

