/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.util.Function;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearFragmentGenerator {
    private static final int SHORT_FRAGMENT_MAX_SIZE = 10;
    private static final int MAX_SEARCH_SIZE = 10;
    @NotNull
    private final LiteLinearGraph myLinearGraph;
    @NotNull
    private final Set<Integer> myPinnedNodes;
    private final Function<Integer, List<Integer>> upNodesFun;
    private final Function<Integer, List<Integer>> downNodesFun;

    public LinearFragmentGenerator(@NotNull LiteLinearGraph linearGraph, @NotNull Set<Integer> pinnedNodes) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/visible/LinearFragmentGenerator", "<init>"));
        }
        if (pinnedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pinnedNodes", "com/intellij/vcs/log/graph/impl/visible/LinearFragmentGenerator", "<init>"));
        }
        this.upNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return LinearFragmentGenerator.this.myLinearGraph.getNodes(integer, LiteLinearGraph.NodeFilter.UP);
            }
        };
        this.downNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return LinearFragmentGenerator.this.myLinearGraph.getNodes(integer, LiteLinearGraph.NodeFilter.DOWN);
            }
        };
        this.myLinearGraph = linearGraph;
        this.myPinnedNodes = pinnedNodes;
    }

    @Nullable
    public GraphFragment getRelativeFragment(@NotNull GraphElement element) {
        int downNodeIndex;
        int upNodeIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/visible/LinearFragmentGenerator", "getRelativeFragment"));
        }
        if (element instanceof GraphNode) {
            downNodeIndex = upNodeIndex = ((GraphNode)element).getNodeIndex();
        } else {
            NormalEdge graphEdge = LinearGraphUtils.asNormalEdge((GraphEdge)element);
            if (graphEdge == null) {
                return null;
            }
            upNodeIndex = graphEdge.up;
            downNodeIndex = graphEdge.down;
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            GraphFragment graphFragment = this.getDownFragment(upNodeIndex);
            if (graphFragment != null && graphFragment.downNodeIndex >= downNodeIndex) {
                return graphFragment;
            }
            List<Integer> upNodes = this.myLinearGraph.getNodes(upNodeIndex, LiteLinearGraph.NodeFilter.UP);
            if (upNodes.size() != 1) break;
            upNodeIndex = upNodes.get(0);
        }
        return null;
    }

    @Nullable
    public GraphFragment getDownFragment(int upperVisibleNodeIndex) {
        return LinearFragmentGenerator.getFragment(upperVisibleNodeIndex, this.downNodesFun, this.upNodesFun, this.myPinnedNodes, true);
    }

    @Nullable
    public GraphFragment getUpFragment(int lowerNodeIndex) {
        return LinearFragmentGenerator.getFragment(lowerNodeIndex, this.upNodesFun, this.downNodesFun, this.myPinnedNodes, false);
    }

    @Nullable
    public GraphFragment getLongDownFragment(int rowIndex) {
        return this.getLongFragment(this.getDownFragment(rowIndex), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getLongFragment(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/visible/LinearFragmentGenerator", "getLongFragment"));
        }
        return this.getLongFragment(this.getRelativeFragment(element), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getPartLongFragment(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/visible/LinearFragmentGenerator", "getPartLongFragment"));
        }
        return this.getLongFragment(this.getRelativeFragment(element), 500);
    }

    @Nullable
    private GraphFragment getLongFragment(@Nullable GraphFragment startFragment, int bound) {
        GraphFragment shortFragment;
        if (startFragment == null) {
            return null;
        }
        int maxDown = startFragment.downNodeIndex;
        while ((shortFragment = this.getDownFragment(maxDown)) != null && !this.myPinnedNodes.contains(maxDown) && (maxDown = shortFragment.downNodeIndex) - startFragment.downNodeIndex <= bound) {
        }
        int maxUp = startFragment.upNodeIndex;
        while ((shortFragment = this.getUpFragment(maxUp)) != null && !this.myPinnedNodes.contains(maxUp) && startFragment.upNodeIndex - (maxUp = shortFragment.upNodeIndex) <= bound) {
        }
        if (maxUp != startFragment.upNodeIndex || maxDown != startFragment.downNodeIndex) {
            return new GraphFragment(maxUp, maxDown);
        }
        if (this.myLinearGraph.getNodes(startFragment.upNodeIndex, LiteLinearGraph.NodeFilter.DOWN).size() != 1) {
            return startFragment;
        }
        return null;
    }

    @Nullable
    private static GraphFragment getFragment(int startNode, Function<Integer, List<Integer>> getNextNodes, Function<Integer, List<Integer>> getPrevNodes, Set<Integer> thisNodeCantBeInMiddle, boolean isDown) {
        HashSet<Integer> blackNodes = new HashSet<Integer>();
        blackNodes.add(startNode);
        HashSet grayNodes = new HashSet();
        grayNodes.addAll((Collection)getNextNodes.fun((Object)startNode));
        int endNode = -1;
        while (blackNodes.size() < 10) {
            int nextBlackNode = -1;
            Iterator iterator = grayNodes.iterator();
            while (iterator.hasNext()) {
                int grayNode = (Integer)iterator.next();
                if (!blackNodes.containsAll((Collection)getPrevNodes.fun((Object)grayNode))) continue;
                nextBlackNode = grayNode;
                break;
            }
            if (nextBlackNode == -1) {
                return null;
            }
            if (grayNodes.size() == 1) {
                endNode = nextBlackNode;
                break;
            }
            List nextGrayNodes = (List)getNextNodes.fun((Object)nextBlackNode);
            if (nextGrayNodes.isEmpty() || thisNodeCantBeInMiddle.contains(nextBlackNode)) {
                return null;
            }
            blackNodes.add(nextBlackNode);
            grayNodes.remove(nextBlackNode);
            grayNodes.addAll(nextGrayNodes);
        }
        if (endNode != -1) {
            return isDown ? GraphFragment.create(startNode, endNode) : GraphFragment.create(endNode, startNode);
        }
        return null;
    }

    public static class GraphFragment {
        public final int upNodeIndex;
        public final int downNodeIndex;

        public GraphFragment(int upNodeIndex, int downNodeIndex) {
            this.upNodeIndex = upNodeIndex;
            this.downNodeIndex = downNodeIndex;
        }

        public static GraphFragment create(int startNode, int endNode) {
            return new GraphFragment(startNode, endNode);
        }
    }
}

