/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranchCreator;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranchMerger;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BekSorter {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final GraphLayoutImpl myGraphLayout;
    @NotNull
    private final TimestampGetter myTimestampGetter;

    @NotNull
    public static BekIntMap createBekMap(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout, @NotNull TimestampGetter timestampGetter) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "createBekMap"));
        }
        if (graphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphLayout", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "createBekMap"));
        }
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "createBekMap"));
        }
        BekSorter bekSorter = new BekSorter(permanentGraph, graphLayout, timestampGetter);
        List<Integer> result2 = bekSorter.getResult();
        assert (result2.size() == permanentGraph.nodesCount());
        BekIntMap bekIntMap = BekSorter.createBekIntMap(result2);
        if (bekIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "createBekMap"));
        }
        return bekIntMap;
    }

    private static BekIntMap createBekIntMap(final List<Integer> result2) {
        int[] reverseMap = new int[result2.size()];
        for (int i2 = 0; i2 < result2.size(); ++i2) {
            reverseMap[result2.get((int)i2).intValue()] = i2;
        }
        final IntList compressedBekMap = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return result2.size();
            }

            @Override
            public int get(int index) {
                return (Integer)result2.get(index);
            }
        }, 30);
        final IntList compressedReverseMap = CompressedIntList.newInstance(reverseMap);
        return new BekIntMap(){

            @Override
            public int size() {
                return compressedBekMap.size();
            }

            @Override
            public int getBekIndex(int usualIndex) {
                return compressedReverseMap.get(usualIndex);
            }

            @Override
            public int getUsualIndex(int bekIndex) {
                return compressedBekMap.get(bekIndex);
            }
        };
    }

    private BekSorter(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout, @NotNull TimestampGetter timestampGetter) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "<init>"));
        }
        if (graphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphLayout", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "<init>"));
        }
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter", "<init>"));
        }
        this.myPermanentGraph = permanentGraph;
        this.myGraphLayout = graphLayout;
        this.myTimestampGetter = timestampGetter;
    }

    public List<Integer> getResult() {
        BekBranchCreator bekBranchCreator = new BekBranchCreator(this.myPermanentGraph, this.myGraphLayout);
        Pair<List<BekBranch>, BekEdgeRestrictions> branches = bekBranchCreator.getResult();
        BekBranchMerger bekBranchMerger = new BekBranchMerger((List)branches.first, (BekEdgeRestrictions)branches.second, this.myTimestampGetter);
        return bekBranchMerger.getResult();
    }
}

