/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.CommitCountStage;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.FakeVisiblePackBuilder;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.data.VisiblePackBuilder;
import com.intellij.vcs.log.data.VisiblePackChangeListener;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFiltererImpl
implements VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(VcsLogFiltererImpl.class);
    @NotNull
    private final SingleTaskController<Request, VisiblePack> myTaskController;
    @NotNull
    private final VisiblePackBuilder myVisiblePackBuilder;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private VcsLogFilterCollection myFilters;
    @NotNull
    private PermanentGraph.SortType mySortType;
    @NotNull
    private CommitCountStage myCommitCount;
    @NotNull
    private List<MoreCommitsRequest> myRequestsToRun;
    @NotNull
    private List<VisiblePackChangeListener> myVisiblePackChangeListeners;
    @NotNull
    private volatile VisiblePack myVisiblePack;
    private volatile boolean myIsValid;

    public VcsLogFiltererImpl(final @NotNull Project project2, @NotNull VcsLogData logData, @NotNull PermanentGraph.SortType initialSortType) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (initialSortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSortType", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        this.myCommitCount = CommitCountStage.INITIAL;
        this.myRequestsToRun = ContainerUtil.newArrayList();
        this.myVisiblePackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myIsValid = true;
        this.myLogData = logData;
        this.myVisiblePackBuilder = this.myLogData.createVisiblePackBuilder();
        this.myFilters = new VcsLogFilterCollectionImpl(null, null, null, null, null, null, null);
        this.mySortType = initialSortType;
        this.myTaskController = new SingleTaskController<Request, VisiblePack>(visiblePack -> {
            this.myVisiblePack = visiblePack;
            for (VisiblePackChangeListener listener2 : this.myVisiblePackChangeListeners) {
                listener2.onVisiblePackChange((VisiblePack)visiblePack);
            }
        }){

            @Override
            protected void startNewBackgroundTask() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogFiltererImpl$1", "lambda$startNewBackgroundTask$0"));
                    }
                    MyTask task = new MyTask(project2, "Applying filters...");
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, VcsLogFiltererImpl.this.myLogData.getProgress().createProgressIndicator());
                });
            }
        };
    }

    @Override
    public void addVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "addVisiblePackChangeListener"));
        }
        this.myVisiblePackChangeListeners.add(listener2);
    }

    @Override
    public void removeVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "removeVisiblePackChangeListener"));
        }
        this.myVisiblePackChangeListeners.remove(listener2);
    }

    @Override
    public void onRefresh() {
        this.myTaskController.request(new RefreshRequest());
    }

    @Override
    public void setValid(boolean validate) {
        this.myTaskController.request(new ValidateRequest(validate));
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        if (newFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFilters", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "onFiltersChange"));
        }
        this.myTaskController.request(new FilterRequest(newFilters));
    }

    @Override
    public void onSortTypeChange(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "onSortTypeChange"));
        }
        this.myTaskController.request(new SortTypeRequest(sortType));
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "moreCommitsNeeded"));
        }
        this.myTaskController.request(new MoreCommitsRequest(onLoaded));
    }

    @Override
    public boolean isValid() {
        return this.myIsValid;
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            if (onLoaded == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MoreCommitsRequest", "<init>"));
            }
            this.onLoaded = onLoaded;
        }
    }

    private static final class SortTypeRequest
    implements Request {
        private final PermanentGraph.SortType sortType;

        SortTypeRequest(PermanentGraph.SortType sortType) {
            this.sortType = sortType;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }
    }

    private static final class ValidateRequest
    implements Request {
        private final boolean validate;

        private ValidateRequest(boolean validate) {
            this.validate = validate;
        }
    }

    private static final class RefreshRequest
    implements Request {
        private RefreshRequest() {
        }
    }

    private static interface Request {
    }

    private class MyTask
    extends Task.Backgroundable {
        public MyTask(@NotNull Project project2, String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MyTask", "<init>"));
            }
            super(project2, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            List<Request> requests;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MyTask", "run"));
            }
            VisiblePack visiblePack = null;
            while (!(requests = VcsLogFiltererImpl.this.myTaskController.popRequests()).isEmpty()) {
                try {
                    visiblePack = this.getVisiblePack(visiblePack, requests);
                }
                catch (ProcessCanceledException reThrown) {
                    throw reThrown;
                }
                catch (Throwable t) {
                    LOG.error("Error while filtering log", t);
                }
            }
            VcsLogFiltererImpl.this.myTaskController.taskCompleted(visiblePack);
            if (visiblePack != null && VcsLogFiltererImpl.this.myIsValid) {
                List requestsToRun = VcsLogFiltererImpl.this.myRequestsToRun;
                VcsLogFiltererImpl.this.myRequestsToRun = ContainerUtil.newArrayList();
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (MoreCommitsRequest request : requestsToRun) {
                        request.onLoaded.run();
                    }
                });
            }
        }

        @Nullable
        private VisiblePack getVisiblePack(@Nullable VisiblePack visiblePack, @NotNull List<Request> requests) {
            if (requests == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MyTask", "getVisiblePack"));
            }
            ValidateRequest validateRequest = (ValidateRequest)ContainerUtil.findLastInstance(requests, ValidateRequest.class);
            FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
            SortTypeRequest sortTypeRequest = (SortTypeRequest)ContainerUtil.findLastInstance(requests, SortTypeRequest.class);
            List moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class);
            VcsLogFiltererImpl.this.myRequestsToRun.addAll(moreCommitsRequests);
            if (filterRequest != null) {
                VcsLogFiltererImpl.this.myFilters = filterRequest.filters;
            }
            if (sortTypeRequest != null) {
                VcsLogFiltererImpl.this.mySortType = sortTypeRequest.sortType;
            }
            if (!VcsLogFiltererImpl.this.myIsValid) {
                if (validateRequest != null && validateRequest.validate) {
                    VcsLogFiltererImpl.this.myIsValid = true;
                    return this.refresh(visiblePack, filterRequest, moreCommitsRequests);
                }
                return visiblePack;
            }
            if (validateRequest != null && !validateRequest.validate) {
                VisiblePack frozenVisiblePack;
                VcsLogFiltererImpl.this.myIsValid = false;
                VisiblePack visiblePack2 = frozenVisiblePack = visiblePack == null ? VcsLogFiltererImpl.this.myVisiblePack : visiblePack;
                if (filterRequest != null) {
                    frozenVisiblePack = this.refresh(visiblePack, filterRequest, moreCommitsRequests);
                }
                return new FakeVisiblePackBuilder(VcsLogFiltererImpl.this.myLogData.getHashMap()).build(frozenVisiblePack);
            }
            Request nonValidateRequest = (Request)ContainerUtil.find(requests, request -> !(request instanceof ValidateRequest));
            if (nonValidateRequest != null) {
                return this.refresh(visiblePack, filterRequest, moreCommitsRequests);
            }
            return visiblePack;
        }

        private VisiblePack refresh(@Nullable VisiblePack visiblePack, @Nullable FilterRequest filterRequest, @NotNull List<MoreCommitsRequest> moreCommitsRequests) {
            if (moreCommitsRequests == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moreCommitsRequests", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MyTask", "refresh"));
            }
            DataPack dataPack = VcsLogFiltererImpl.this.myLogData.getDataPack();
            if (dataPack == DataPack.EMPTY) {
                return visiblePack;
            }
            if (filterRequest != null) {
                VcsLogFiltererImpl.this.myCommitCount = CommitCountStage.INITIAL;
            } else if (!moreCommitsRequests.isEmpty()) {
                VcsLogFiltererImpl.this.myCommitCount = VcsLogFiltererImpl.this.myCommitCount.next();
            }
            Pair<VisiblePack, CommitCountStage> pair = VcsLogFiltererImpl.this.myVisiblePackBuilder.build(dataPack, VcsLogFiltererImpl.this.mySortType, VcsLogFiltererImpl.this.myFilters, VcsLogFiltererImpl.this.myCommitCount);
            visiblePack = (VisiblePack)pair.first;
            VcsLogFiltererImpl.this.myCommitCount = (CommitCountStage)((Object)pair.second);
            return visiblePack;
        }
    }
}

