/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.CommitId;
import org.jetbrains.annotations.NotNull;

public class CommitIdByStringCondition
implements Condition<CommitId> {
    @NotNull
    private final String myHashString;

    public CommitIdByStringCondition(@NotNull String hashString) {
        if (hashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashString", "com/intellij/vcs/log/data/CommitIdByStringCondition", "<init>"));
        }
        this.myHashString = hashString;
    }

    public boolean value(CommitId commitId) {
        return StringUtil.startsWithIgnoreCase((String)commitId.getHash().asString(), (String)this.myHashString);
    }
}

