/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;

class StableInvocationHandler<T>
implements InvocationHandler,
StableElement {
    private T myOldValue;
    private T myCachedValue;
    private final Set<Class> myClasses;
    private final Factory<T> myProvider;
    private final Condition<T> myValidator;

    public StableInvocationHandler(T initial, Factory<T> provider, Condition<T> validator) {
        this.myProvider = provider;
        this.myCachedValue = initial;
        this.myOldValue = initial;
        this.myValidator = validator;
        Class<?> superClass = initial.getClass().getSuperclass();
        HashSet<Class> classes = new HashSet<Class>();
        ContainerUtil.addAll(classes, (Object[])initial.getClass().getInterfaces());
        ContainerUtil.addIfNotNull(classes, superClass);
        classes.remove(MergedObject.class);
        this.myClasses = classes;
    }

    public final Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
        if (StableElement.class.equals(method2.getDeclaringClass())) {
            try {
                return method2.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        if (AdvancedProxy.FINALIZE_METHOD.equals(method2)) {
            return null;
        }
        if (this.isNotValid(this.myCachedValue)) {
            if (this.myCachedValue != null) {
                this.myOldValue = this.myCachedValue;
            }
            this.myCachedValue = this.myProvider.create();
            if (this.isNotValid(this.myCachedValue)) {
                if (AdvancedProxy.EQUALS_METHOD.equals(method2)) {
                    Object arg = args[0];
                    if (!(arg instanceof StableElement)) {
                        return false;
                    }
                    StableInvocationHandler handler2 = DomManagerImpl.getStableInvocationHandler(arg);
                    if (handler2 == null || handler2.getWrappedElement() != null) {
                        return false;
                    }
                    return Comparing.equal(this.myOldValue, handler2.myOldValue);
                }
                if (this.myOldValue != null && Object.class.equals(method2.getDeclaringClass())) {
                    return method2.invoke(this.myOldValue, args);
                }
                if ("isValid".equals(method2.getName())) {
                    return Boolean.FALSE;
                }
                throw new AssertionError((Object)"Calling methods on invalid value");
            }
        }
        if (AdvancedProxy.EQUALS_METHOD.equals(method2)) {
            Object arg = args[0];
            if (arg instanceof StableElement) {
                return this.myCachedValue.equals(((StableElement)arg).getWrappedElement());
            }
            return this.myCachedValue.equals(arg);
        }
        if (AdvancedProxy.HASHCODE_METHOD.equals(method2)) {
            return this.myCachedValue.hashCode();
        }
        try {
            return method2.invoke(this.myCachedValue, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void revalidate() {
        Object t = this.myProvider.create();
        if (!this.isNotValid(t) && !t.equals(this.myCachedValue)) {
            this.myCachedValue = t;
        }
    }

    public final void invalidate() {
        if (!this.isNotValid(this.myCachedValue)) {
            this.myCachedValue = null;
        }
    }

    public final T getWrappedElement() {
        if (this.isNotValid(this.myCachedValue)) {
            this.myCachedValue = this.myProvider.create();
        }
        return this.myCachedValue;
    }

    public T getOldValue() {
        return this.myOldValue;
    }

    private boolean isNotValid(T t) {
        if (t == null || !this.myValidator.value(t)) {
            return true;
        }
        for (Class aClass : this.myClasses) {
            if (aClass.isInstance(t)) continue;
            return true;
        }
        return false;
    }
}

