/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeHttpClientHelpers {
    private IdeHttpClientHelpers() {
    }

    @NotNull
    private static HttpConfigurable getHttpConfigurable() {
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        if (httpConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/IdeHttpClientHelpers", "getHttpConfigurable"));
        }
        return httpConfigurable;
    }

    private static boolean isHttpProxyEnabled() {
        return IdeHttpClientHelpers.getHttpConfigurable().USE_HTTP_PROXY;
    }

    private static boolean isProxyAuthenticationEnabled() {
        return IdeHttpClientHelpers.getHttpConfigurable().PROXY_AUTHENTICATION;
    }

    @NotNull
    private static String getProxyHost() {
        String string = StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().PROXY_HOST);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/IdeHttpClientHelpers", "getProxyHost"));
        }
        return string;
    }

    private static int getProxyPort() {
        return IdeHttpClientHelpers.getHttpConfigurable().PROXY_PORT;
    }

    @NotNull
    private static String getProxyLogin() {
        String string = StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().getProxyLogin());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/IdeHttpClientHelpers", "getProxyLogin"));
        }
        return string;
    }

    @NotNull
    private static String getProxyPassword() {
        String string = StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().getPlainProxyPassword());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/IdeHttpClientHelpers", "getProxyPassword"));
        }
        return string;
    }

    public static final class ApacheHttpClient4 {
        public static void setProxyIfEnabled(@NotNull RequestConfig.Builder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/net/IdeHttpClientHelpers$ApacheHttpClient4", "setProxyIfEnabled"));
            }
            if (IdeHttpClientHelpers.isHttpProxyEnabled()) {
                builder.setProxy(new HttpHost(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort()));
            }
        }

        public static void setProxyCredentialsIfEnabled(@NotNull CredentialsProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/net/IdeHttpClientHelpers$ApacheHttpClient4", "setProxyCredentialsIfEnabled"));
            }
            if (IdeHttpClientHelpers.isHttpProxyEnabled() && IdeHttpClientHelpers.isProxyAuthenticationEnabled()) {
                String ntlmUserPassword = IdeHttpClientHelpers.getProxyLogin().replace('\\', '/') + ":" + IdeHttpClientHelpers.getProxyPassword();
                provider.setCredentials(new AuthScope(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort(), AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(ntlmUserPassword));
                provider.setCredentials(new AuthScope(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort()), (Credentials)new UsernamePasswordCredentials(IdeHttpClientHelpers.getProxyLogin(), IdeHttpClientHelpers.getProxyPassword()));
            }
        }

        public static void setProxyForUrlIfEnabled(@NotNull RequestConfig.Builder builder, @Nullable String url) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/net/IdeHttpClientHelpers$ApacheHttpClient4", "setProxyForUrlIfEnabled"));
            }
            if (IdeHttpClientHelpers.getHttpConfigurable().isHttpProxyEnabledForUrl(url)) {
                ApacheHttpClient4.setProxyIfEnabled(builder);
            }
        }

        public static void setProxyCredentialsForUrlIfEnabled(@NotNull CredentialsProvider provider, @Nullable String url) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/net/IdeHttpClientHelpers$ApacheHttpClient4", "setProxyCredentialsForUrlIfEnabled"));
            }
            if (IdeHttpClientHelpers.getHttpConfigurable().isHttpProxyEnabledForUrl(url)) {
                ApacheHttpClient4.setProxyCredentialsIfEnabled(provider);
            }
        }
    }
}

