/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

enum RebuildStatus {
    OK,
    REQUIRES_REBUILD,
    DOING_REBUILD;

    private static final Map<ID<?, ?>, AtomicReference<RebuildStatus>> ourRebuildStatus;

    static void registerIndex(ID<?, ?> indexId) {
        ourRebuildStatus.put(indexId, new AtomicReference<RebuildStatus>(OK));
    }

    static boolean isOk(ID<?, ?> indexId) {
        return ourRebuildStatus.get(indexId).get() == OK;
    }

    static boolean requestRebuild(ID<?, ?> indexId) {
        return ourRebuildStatus.get(indexId).compareAndSet(OK, REQUIRES_REBUILD);
    }

    static void clearIndexIfNecessary(ID<?, ?> indexId, ThrowableRunnable<StorageException> clearAction) throws StorageException {
        AtomicReference<RebuildStatus> rebuildStatus = ourRebuildStatus.get(indexId);
        if (rebuildStatus == null) {
            throw new StorageException("Problem updating " + indexId);
        }
        if (rebuildStatus.compareAndSet(REQUIRES_REBUILD, DOING_REBUILD)) {
            RebuildStatus.doClear(clearAction, rebuildStatus);
        } else {
            RebuildStatus.waitUntilIndexReady(rebuildStatus);
        }
    }

    private static void doClear(ThrowableRunnable<StorageException> clearAction, AtomicReference<RebuildStatus> status) throws StorageException {
        try {
            clearAction.run();
        }
        catch (StorageException e) {
            status.compareAndSet(DOING_REBUILD, REQUIRES_REBUILD);
            throw e;
        }
        if (!status.compareAndSet(DOING_REBUILD, OK)) {
            FileBasedIndexImpl.LOG.error("Unexpected status " + (Object)((Object)status.get()));
        }
    }

    private static void waitUntilIndexReady(AtomicReference<RebuildStatus> rebuildStatus) {
        while (rebuildStatus.get() != OK) {
            ProgressManager.checkCanceled();
            TimeoutUtil.sleep((long)50L);
        }
    }

    static {
        ourRebuildStatus = ContainerUtil.newTroveMap();
    }
}

