/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private final Project myProject;
    private volatile Set<VirtualFile> cachedFiles;
    private volatile Set<VirtualFile> cachedDirectories;
    private volatile IndexableSetContributor[] myExtensions;

    public AdditionalIndexableFileSet(Project project2, IndexableSetContributor ... extensions) {
        this.myProject = project2;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet(Project project2) {
        this.myProject = project2;
    }

    public AdditionalIndexableFileSet(IndexableSetContributor ... extensions) {
        this.myProject = null;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet() {
        this.myProject = null;
    }

    private Set<VirtualFile> getDirectories() {
        Set<VirtualFile> directories = this.cachedDirectories;
        if (directories == null || VfsUtilCore.hasInvalidFiles(directories) || VfsUtilCore.hasInvalidFiles(this.cachedFiles)) {
            directories = this.collectFilesAndDirectories();
        }
        return directories;
    }

    private THashSet<VirtualFile> collectFilesAndDirectories() {
        THashSet files = new THashSet();
        THashSet directories = new THashSet();
        if (this.myExtensions == null) {
            this.myExtensions = (IndexableSetContributor[])Extensions.getExtensions((ExtensionPointName)IndexableSetContributor.EP_NAME);
        }
        for (IndexableSetContributor contributor : this.myExtensions) {
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                (root.isDirectory() ? directories : files).add((Object)root);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                (root.isDirectory() ? directories : files).add((Object)root);
            }
        }
        this.cachedFiles = files;
        this.cachedDirectories = directories;
        return directories;
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet", "isInSet"));
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, this.getDirectories()) || this.cachedFiles.contains(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet", "iterateIndexableFilesIn"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/indexing/AdditionalIndexableFileSet", "iterateIndexableFilesIn"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet$1", "visitFile"));
                }
                if (!AdditionalIndexableFileSet.this.isInSet(file2)) {
                    return false;
                }
                if (!file2.isDirectory()) {
                    iterator.processFile(file2);
                }
                return true;
            }
        });
    }
}

