/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

abstract class GeneralRunner
implements ContinuationContext {
    protected final Project myProject;
    protected final boolean myCancellable;
    protected final List<TaskDescriptor> myQueue;
    protected final Object myQueueLock;
    private boolean myTriggerSuspend;
    private ProgressIndicator myIndicator;
    private final Map<Class<? extends Exception>, Consumer<Exception>> myHandlersMap;

    GeneralRunner(Project project2, boolean cancellable) {
        this.myProject = project2;
        this.myCancellable = cancellable;
        this.myQueueLock = new Object();
        this.myQueue = new LinkedList<TaskDescriptor>();
        this.myHandlersMap = new HashMap<Class<? extends Exception>, Consumer<Exception>>();
        this.myTriggerSuspend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Exception> void addExceptionHandler(Class<T> clazz, Consumer<T> consumer) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myHandlersMap.put(clazz, (Consumer<Exception>)((Consumer)e -> {
                if (!clazz.isAssignableFrom(e.getClass())) {
                    throw new RuntimeException((Throwable)e);
                }
                consumer.consume(e);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIndicator(ProgressIndicator indicator) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myIndicator = indicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleException(Exception e, boolean cancelEveryThing) {
        Object object = this.myQueueLock;
        synchronized (object) {
            try {
                Map.Entry<Class<? extends Exception>, Consumer<Exception>> entry;
                Class<?> aClass = e.getClass();
                Consumer<Exception> consumer = this.myHandlersMap.get(e.getClass());
                if (consumer != null) {
                    consumer.consume((Object)e);
                    boolean bl = true;
                    return bl;
                }
                Iterator<Map.Entry<Class<? extends Exception>, Consumer<Exception>>> iterator = this.myHandlersMap.entrySet().iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!(entry = iterator.next()).getKey().isAssignableFrom(aClass));
                entry.getValue().consume((Object)e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (cancelEveryThing) {
                    this.cancelEverything();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEverything() {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myQueue.forEach(TaskDescriptor::canceled);
            this.myQueue.clear();
            this.myIndicator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myTriggerSuspend = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getSuspendFlag() {
        Object object = this.myQueueLock;
        synchronized (object) {
            return this.myTriggerSuspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSuspend() {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myTriggerSuspend = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(TaskDescriptor ... next) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myQueue.addAll(0, Arrays.asList(next));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(List<TaskDescriptor> next) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myQueue.addAll(0, next);
        }
    }

    public abstract void ping();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TaskDescriptor getNextMatching() {
        while (true) {
            Object object = this.myQueueLock;
            synchronized (object) {
                if (this.myQueue.isEmpty()) {
                    return null;
                }
                TaskDescriptor current = this.myQueue.remove(0);
                if (current.isHaveMagicCure() || this.myIndicator == null || !this.myIndicator.isCanceled()) {
                    return current;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressIndicator getIndicator() {
        Object object = this.myQueueLock;
        synchronized (object) {
            return this.myIndicator;
        }
    }
}

