/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;

public class PsiErrorElementUtil {
    private static final Key<CachedValue<Boolean>> CONTAINS_ERROR_ELEMENT = Key.create((String)"CONTAINS_ERROR_ELEMENT");

    private PsiErrorElementUtil() {
    }

    public static boolean hasErrors(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/PsiErrorElementUtil", "hasErrors"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/util/PsiErrorElementUtil", "hasErrors"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/PsiErrorElementUtil", "lambda$hasErrors$0"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/util/PsiErrorElementUtil", "lambda$hasErrors$0"));
            }
            if (project2.isDisposed() || !virtualFile.isValid()) {
                return false;
            }
            PsiManagerEx psiManager = PsiManagerEx.getInstanceEx(project2);
            PsiFile psiFile = psiManager.getFileManager().findFile(virtualFile);
            return psiFile != null && PsiErrorElementUtil.hasErrors(psiFile);
        });
    }

    private static boolean hasErrors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/util/PsiErrorElementUtil", "hasErrors"));
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)psiFile.getProject());
        return (Boolean)cachedValuesManager.getCachedValue((UserDataHolder)psiFile, CONTAINS_ERROR_ELEMENT, () -> {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/util/PsiErrorElementUtil", "lambda$hasErrors$1"));
            }
            return CachedValueProvider.Result.create((Object)PsiErrorElementUtil.hasErrorElements((PsiElement)psiFile), (Object[])new Object[]{psiFile});
        }, false);
    }

    private static boolean hasErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/PsiErrorElementUtil", "hasErrorElements"));
        }
        HighlightErrorFilter[] filters = null;
        for (PsiErrorElement error : SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(PsiErrorElement.class)) {
            if (filters == null) {
                filters = (HighlightErrorFilter[])HighlightErrorFilter.EP_NAME.getExtensions((AreaInstance)element.getProject());
            }
            if (!PsiErrorElementUtil.shouldHighlightErrorElement(error, filters)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldHighlightErrorElement(@NotNull PsiErrorElement error, @NotNull HighlightErrorFilter[] filters) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/util/PsiErrorElementUtil", "shouldHighlightErrorElement"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/util/PsiErrorElementUtil", "shouldHighlightErrorElement"));
        }
        for (HighlightErrorFilter filter : filters) {
            if (filter.shouldHighlightErrorElement(error)) continue;
            return false;
        }
        return true;
    }
}

