/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.notification.impl.ui.StickyButton;
import com.intellij.notification.impl.ui.StickyButtonUI;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSelectionComponent
extends JPanel {
    private static final String CUSTOM_COLOR_NAME = "Custom";
    private Map<String, ColorButton> myColorToButtonMap = new LinkedHashMap<String, ColorButton>();
    private final ButtonGroup myButtonGroup = new ButtonGroup();
    private ChangeListener myChangeListener;

    public ColorSelectionComponent() {
        super(new GridLayout(1, 0, 5, 5));
        this.setOpaque(false);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.myChangeListener = changeListener;
    }

    public void setSelectedColor(String colorName) {
        AbstractButton button = this.myColorToButtonMap.get(colorName);
        if (button != null) {
            button.setSelected(true);
        }
    }

    @NotNull
    public Collection<String> getColorNames() {
        Set<String> set2 = this.myColorToButtonMap.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/ColorSelectionComponent", "getColorNames"));
        }
        return set2;
    }

    @Nullable
    public String getColorName(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        for (String name : this.myColorToButtonMap.keySet()) {
            if (color.getRGB() != this.myColorToButtonMap.get(name).getColor().getRGB()) continue;
            return name;
        }
        return null;
    }

    public void addCustomColorButton() {
        CustomColorButton customButton = new CustomColorButton();
        this.myButtonGroup.add(customButton);
        this.add(customButton);
        this.myColorToButtonMap.put(customButton.getText(), customButton);
    }

    public void addColorButton(@NotNull String name, @NotNull Color color) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tabs/ColorSelectionComponent", "addColorButton"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/ui/tabs/ColorSelectionComponent", "addColorButton"));
        }
        ColorButton colorButton = new ColorButton(name, color);
        this.myButtonGroup.add(colorButton);
        this.add(colorButton);
        this.myColorToButtonMap.put(name, colorButton);
    }

    public void setCustomButtonColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/ui/tabs/ColorSelectionComponent", "setCustomButtonColor"));
        }
        CustomColorButton button = (CustomColorButton)this.myColorToButtonMap.get(CUSTOM_COLOR_NAME);
        button.setColor(color);
        button.setSelected(true);
        button.repaint();
    }

    @Nullable
    public String getSelectedColorName() {
        for (String name : this.myColorToButtonMap.keySet()) {
            ColorButton button = this.myColorToButtonMap.get(name);
            if (!button.isSelected()) continue;
            if (button instanceof CustomColorButton) {
                String color = ColorUtil.toHex((Color)button.getColor());
                String colorName = ColorSelectionComponent.findColorName(button.getColor());
                return colorName == null ? color : colorName;
            }
            return name;
        }
        return null;
    }

    @Nullable
    public static String findColorName(Color color) {
        String hex = ColorUtil.toHex((Color)color);
        if ("ffffe4".equals(hex) || "494539".equals(hex)) {
            return "Yellow";
        }
        if ("e7fadb".equals(hex) || "2a3b2c".equals(hex)) {
            return "Green";
        }
        return null;
    }

    @Nullable
    public Color getSelectedColor() {
        for (String name : this.myColorToButtonMap.keySet()) {
            ColorButton button = this.myColorToButtonMap.get(name);
            if (!button.isSelected()) continue;
            return button.getColor();
        }
        return null;
    }

    public void initDefault(@NotNull FileColorManager manager, @Nullable String selectedColorName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/tabs/ColorSelectionComponent", "initDefault"));
        }
        for (String name : manager.getColorNames()) {
            this.addColorButton(name, (Color)ObjectUtils.assertNotNull((Object)manager.getColor(name)));
        }
        this.addCustomColorButton();
        this.setSelectedColor(selectedColorName);
    }

    public void stateChanged() {
        if (this.myChangeListener != null) {
            this.myChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private static class ColorButtonUI
    extends StickyButtonUI<ColorButton> {
        private ColorButtonUI() {
        }

        @Override
        protected Color getBackgroundColor(ColorButton button) {
            return button.getColor();
        }

        @Override
        protected Color getFocusColor(ColorButton button) {
            return button.getColor().darker();
        }

        @Override
        protected Color getSelectionColor(ColorButton button) {
            return button.getColor();
        }

        @Override
        protected Color getRolloverColor(ColorButton button) {
            return button.getColor();
        }

        @Override
        protected int getArcSize() {
            return 20;
        }
    }

    private class CustomColorButton
    extends ColorButton {
        private CustomColorButton() {
            super(ColorSelectionComponent.CUSTOM_COLOR_NAME, Color.WHITE);
            this.myColor = null;
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
            Color color = ColorChooser.chooseColor((Component)this, (String)"Choose Color", (Color)this.myColor);
            if (color != null) {
                this.myColor = color;
            }
            this.setSelected(this.myColor != null);
            ColorSelectionComponent.this.stateChanged();
        }

        @Override
        public Color getForeground() {
            return this.getModel().isSelected() ? Color.BLACK : JBColor.GRAY;
        }

        @Override
        Color getColor() {
            return this.myColor == null ? Color.WHITE : this.myColor;
        }
    }

    private class ColorButton
    extends StickyButton {
        protected Color myColor;

        protected ColorButton(String text, Color color) {
            super(FileColorManagerImpl.getAlias(text));
            this.setUI(new ColorButtonUI());
            this.myColor = color;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorButton.this.doPerformAction(e);
                }
            });
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        }

        protected void doPerformAction(ActionEvent e) {
            ColorSelectionComponent.this.stateChanged();
        }

        Color getColor() {
            return this.myColor;
        }

        public void setColor(Color color) {
            this.myColor = color;
        }

        @Override
        public Color getForeground() {
            if (this.getModel().isSelected()) {
                return JBColor.foreground();
            }
            if (this.getModel().isRollover()) {
                return JBColor.GRAY;
            }
            return this.getColor();
        }

        @Override
        protected ButtonUI createUI() {
            return new ColorButtonUI();
        }
    }
}

