/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;

public class ExternalClasspathClassLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseUrls(String classpathFilePath) {
        LinkedHashSet<String> roots = new LinkedHashSet<String>();
        File file2 = new File(classpathFilePath);
        try {
            try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                while (reader.ready()) {
                    roots.add(reader.readLine());
                }
            }
            return roots.toArray(new String[roots.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getRoots() {
        String classPathFilePath = System.getProperty("classpath.file");
        return classPathFilePath != null ? ExternalClasspathClassLoader.parseUrls(classPathFilePath) : null;
    }

    public static String[] getExcludeRoots() {
        try {
            String classPathFilePath = System.getProperty("exclude.tests.roots.file");
            return classPathFilePath != null ? ExternalClasspathClassLoader.parseUrls(classPathFilePath) : null;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static void install() {
        try {
            URL[] urls = ExternalClasspathClassLoader.parseUrls();
            if (urls != null) {
                URLClassLoader auxLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                Thread.currentThread().setContextClassLoader(auxLoader);
                Thread.currentThread().setContextClassLoader(ExternalClasspathClassLoader.loadOptimizedLoader(urls, auxLoader));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader loadOptimizedLoader(Object urls, URLClassLoader auxLoader) throws Exception {
        Object builder = auxLoader.loadClass("com.intellij.util.lang.UrlClassLoader").getMethod("build", new Class[0]).invoke(null, new Object[0]);
        builder.getClass().getMethod("urls", URL[].class).invoke(builder, urls);
        builder.getClass().getMethod("useCache", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("allowLock", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("allowBootstrapResources", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("parent", ClassLoader.class).invoke(builder, auxLoader.getParent());
        return (ClassLoader)builder.getClass().getMethod("get", new Class[0]).invoke(builder, new Object[0]);
    }

    private static URL[] parseUrls() {
        try {
            String[] roots = ExternalClasspathClassLoader.getRoots();
            if (roots == null) {
                return null;
            }
            URL[] urls = new URL[roots.length];
            for (int i2 = 0; i2 < urls.length; ++i2) {
                urls[i2] = new File(roots[i2]).toURI().toURL();
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

