/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/testFramework/TestLogger", "<init>"));
        }
        super(logger);
    }

    public void warn(String message, @Nullable Throwable t) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processWarn(message, t, this.myLogger);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/testFramework/TestLogger", "error"));
        }
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processError(message, t, details, this.myLogger);
    }

    public void debug(@NonNls String message) {
        super.debug(message);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, null);
    }

    public void debug(@Nullable Throwable t) {
        super.debug(t);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t);
    }

    public void debug(@NonNls String message, @Nullable Throwable t) {
        super.debug(message, t);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, t);
    }

    public void info(@NonNls String message) {
        super.info(message);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, null);
    }

    public void info(@NonNls String message, @Nullable Throwable t) {
        super.info(message, t);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, t);
    }

    public boolean isDebugEnabled() {
        return true;
    }
}

