/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.PlatformLiteFixture;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;

public abstract class ParsingTestCase
extends PlatformLiteFixture {
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;

    protected ParsingTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        if (dataPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPath", "com/intellij/testFramework/ParsingTestCase", "<init>"));
        }
        if (fileExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExt", "com/intellij/testFramework/ParsingTestCase", "<init>"));
        }
        if (definitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitions", "com/intellij/testFramework/ParsingTestCase", "<init>"));
        }
        this(dataPath, fileExt, false, definitions);
    }

    protected ParsingTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        if (dataPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPath", "com/intellij/testFramework/ParsingTestCase", "<init>"));
        }
        if (fileExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExt", "com/intellij/testFramework/ParsingTestCase", "<init>"));
        }
        if (definitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitions", "com/intellij/testFramework/ParsingTestCase", "<init>"));
        }
        this.myFilePrefix = "";
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        ComponentAdapter component = ParsingTestCase.getApplication().getPicoContainer().getComponentAdapter((Object)ProgressManager.class.getName());
        if (component == null) {
            ParsingTestCase.getApplication().getPicoContainer().registerComponent((ComponentAdapter)new AbstractComponentAdapter(ProgressManager.class.getName(), Object.class){

                public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                    return new ProgressManagerImpl();
                }

                public void verify(PicoContainer container) throws PicoIntrospectionException {
                }
            });
        }
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager(this.myProject);
        this.myFileFactory = new PsiFileFactoryImpl(this.myPsiManager);
        MutablePicoContainer appContainer = ParsingTestCase.getApplication().getPicoContainer();
        ParsingTestCase.registerComponentInstance(appContainer, MessageBus.class, ParsingTestCase.getApplication().getMessageBus());
        ParsingTestCase.registerComponentInstance(appContainer, SchemeManagerFactory.class, new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        ParsingTestCase.registerComponentInstance(appContainer, EditorFactory.class, editorFactory);
        ParsingTestCase.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl((Function<CharSequence, Document>)((Function)charSequence -> editorFactory.createDocument((CharSequence)charSequence)), FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY));
        ParsingTestCase.registerComponentInstance(appContainer, PsiDocumentManager.class, new MockPsiDocumentManager());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(StartupManager.class, new StartupManagerImpl(this.myProject));
        this.registerExtensionPoint(FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        for (ParserDefinition definition : this.myDefinitions) {
            this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
        }
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
        }
        PomModelImpl pomModel = new PomModelImpl(this.myProject);
        this.myProject.registerService(PomModel.class, pomModel);
        new TreeAspect(pomModel);
    }

    public void configureFromParserDefinition(ParserDefinition definition, String extension) {
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension;
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, this.myLanguage, (Object)definition);
        ParsingTestCase.registerComponentInstance(ParsingTestCase.getApplication().getPicoContainer(), FileTypeManager.class, new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected <T> void addExplicitExtension(final LanguageExtension<T> instance, final Language language, final T object) {
        instance.addExplicitExtension((Object)language, object);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                instance.removeExplicitExtension((Object)language, object);
            }
        });
    }

    @Override
    protected <T> void registerExtensionPoint(final ExtensionPointName<T> extensionPointName, Class<T> aClass) {
        super.registerExtensionPoint(extensionPointName, aClass);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.getRootArea().unregisterExtensionPoint(extensionPointName.getName());
            }
        });
    }

    protected <T> void registerApplicationService(final Class<T> aClass, T object) {
        ParsingTestCase.getApplication().registerService(aClass, object);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                PlatformLiteFixture.getApplication().getPicoContainer().unregisterComponent((Object)aClass.getName());
            }
        });
    }

    @NotNull
    public MockProjectEx getProject() {
        MockProjectEx mockProjectEx = this.myProject;
        if (mockProjectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/ParsingTestCase", "getProject"));
        }
        return mockProjectEx;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.myFile = null;
        this.myProject = null;
        this.myPsiManager = null;
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        String string = this.getTestName(this.myLowercaseFirstLetter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/ParsingTestCase", "getTestName"));
        }
        return string;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void doTest(boolean checkResult) {
        String name = this.getTestName();
        try {
            String text = this.loadFile(name + "." + this.myFileExt);
            this.myFile = this.createPsiFile(name, text);
            ParsingTestCase.ensureParsed(this.myFile);
            ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
            ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text, (Object)LoadTextUtil.loadText(this.myFile.getVirtualFile()));
            ParsingTestCase.assertEquals((String)"doc text mismatch", (String)text, (String)this.myFile.getViewProvider().getDocument().getText());
            ParsingTestCase.assertEquals((String)"psi text mismatch", (String)text, (String)this.myFile.getText());
            ParsingTestCase.ensureCorrectReparse(this.myFile);
            if (checkResult) {
                this.checkResult(name, this.myFile);
            } else {
                ParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doTest(String suffix) throws IOException {
        String name = this.getTestName();
        String text = this.loadFile(name + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name, text);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)text, (String)this.myFile.getText());
        this.checkResult(name + suffix, this.myFile);
    }

    protected void doCodeTest(String code2) throws IOException {
        String name = this.getTestName();
        this.myFile = this.createPsiFile("a", code2);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)code2, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name, this.myFile);
    }

    protected PsiFile createPsiFile(String name, String text) {
        return this.createFile(name + "." + this.myFileExt, text);
    }

    protected PsiFile createFile(@NonNls String name, String text) {
        LightVirtualFile virtualFile = new LightVirtualFile(name, this.myLanguage, (CharSequence)text);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        return this.createFile(virtualFile);
    }

    protected PsiFile createFile(LightVirtualFile virtualFile) {
        return this.myFileFactory.trySetupPsiForFile(virtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NonNls String targetDataName, PsiFile file2) throws IOException {
        ParsingTestCase.doCheckResult(this.myFullDataPath, file2, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges());
    }

    public static void doCheckResult(String testDataDir, PsiFile file2, boolean checkAllPsiRoots, String targetDataName, boolean skipSpaces, boolean printRanges) throws IOException {
        FileViewProvider provider = file2.getViewProvider();
        Set languages = provider.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            ParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", ParsingTestCase.toParseTreeText((PsiElement)file2, skipSpaces, printRanges).trim());
            return;
        }
        for (Language language : languages) {
            PsiFile root = provider.getPsi(language);
            String expectedName = targetDataName + "." + language.getID() + ".txt";
            ParsingTestCase.doCheckResult(testDataDir, expectedName, ParsingTestCase.toParseTreeText((PsiElement)root, skipSpaces, printRanges).trim());
        }
    }

    protected void checkResult(String actual) throws IOException {
        String name = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name + ".txt", actual);
    }

    protected void checkResult(@NonNls String targetDataName, String actual) throws IOException {
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual);
    }

    public static void doCheckResult(String fullPath, String targetDataName, String actual) throws IOException {
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        UsefulTestCase.assertSameLinesWithFile(expectedFileName, actual);
    }

    protected static String toParseTreeText(PsiElement file2, boolean skipSpaces, boolean printRanges) {
        return DebugUtil.psiToString(file2, skipSpaces, printRanges);
    }

    protected String loadFile(@NonNls String name) throws IOException {
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, name);
    }

    public static String loadFileDefault(String dir, String name) throws IOException {
        return FileUtil.loadFile((File)new File(dir, name), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(PsiFile file2) {
        file2.accept(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/ParsingTestCase", "ensureCorrectReparse"));
        }
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)file2, false, false);
        String fileText = file2.getText();
        DiffLog diffLog = new BlockSupportImpl(file2.getProject()).reparseRange(file2, file2.getNode(), TextRange.allOf((String)fileText), fileText, (ProgressIndicator)new EmptyProgressIndicator(), fileText);
        diffLog.performActualPsiChange(file2);
        TestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file2, false, false));
    }
}

