/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.ui.SimpleEditorCustomization;
import com.intellij.util.containers.WeakHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SpellCheckingEditorCustomization
extends SimpleEditorCustomization {
    public static final SpellCheckingEditorCustomization ENABLED = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization();
    public static final SpellCheckingEditorCustomization DISABLED = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
    private static final Map<String, LocalInspectionToolWrapper> SPELL_CHECK_TOOLS = new HashMap<String, LocalInspectionToolWrapper>();
    private static final boolean READY = SpellCheckingEditorCustomization.init();

    @NotNull
    public static SpellCheckingEditorCustomization getInstance(boolean enabled) {
        SpellCheckingEditorCustomization spellCheckingEditorCustomization = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getCustomization(enabled);
        if (spellCheckingEditorCustomization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization", "getInstance"));
        }
        return spellCheckingEditorCustomization;
    }

    SpellCheckingEditorCustomization(boolean enabled) {
        super(enabled);
    }

    private static boolean init() {
        Class[] inspectionClasses;
        for (Class inspectionClass : inspectionClasses = new Class[]{SpellCheckingInspection.class}) {
            try {
                LocalInspectionTool tool = (LocalInspectionTool)inspectionClass.newInstance();
                SPELL_CHECK_TOOLS.put(tool.getShortName(), new LocalInspectionToolWrapper(tool));
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void customize(@NotNull EditorEx editor) {
        DaemonCodeAnalyzer analyzer;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization", "customize"));
        }
        boolean apply2 = this.isEnabled();
        if (!READY) {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return;
        }
        Function strategy = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        if (strategy == null) {
            strategy = new MyInspectionProfileStrategy();
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, (Object)strategy);
        }
        if (!(strategy instanceof MyInspectionProfileStrategy)) {
            return;
        }
        ((MyInspectionProfileStrategy)strategy).setUseSpellCheck(apply2);
        if (apply2) {
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, false);
        }
        if ((analyzer = DaemonCodeAnalyzer.getInstance((Project)project2)) != null) {
            analyzer.restart(file2);
        }
    }

    private static class MyInspectionProfileWrapper
    extends InspectionProfileWrapper {
        private boolean myUseSpellCheck;

        MyInspectionProfileWrapper() {
            super(new InspectionProfileImpl("CommitDialog"));
        }

        @Override
        public boolean isToolEnabled(HighlightDisplayKey key2, PsiElement element) {
            return this.myUseSpellCheck && SPELL_CHECK_TOOLS.containsKey(key2.toString());
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }
    }

    private static class MyInspectionProfileStrategy
    implements Function<InspectionProfileImpl, InspectionProfileWrapper> {
        private final Map<InspectionProfile, MyInspectionProfileWrapper> myWrappers = new WeakHashMap();
        private boolean myUseSpellCheck;

        private MyInspectionProfileStrategy() {
        }

        @Override
        @NotNull
        public InspectionProfileWrapper apply(@NotNull InspectionProfileImpl inspectionProfile) {
            if (inspectionProfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy", "apply"));
            }
            if (!READY) {
                InspectionProfileWrapper inspectionProfileWrapper = new InspectionProfileWrapper(inspectionProfile);
                if (inspectionProfileWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy", "apply"));
                }
                return inspectionProfileWrapper;
            }
            MyInspectionProfileWrapper wrapper = this.myWrappers.get(inspectionProfile);
            if (wrapper == null) {
                wrapper = new MyInspectionProfileWrapper();
                this.myWrappers.put((InspectionProfile)inspectionProfile, wrapper);
            }
            wrapper.setUseSpellCheck(this.myUseSpellCheck);
            MyInspectionProfileWrapper myInspectionProfileWrapper = wrapper;
            if (myInspectionProfileWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy", "apply"));
            }
            return myInspectionProfileWrapper;
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }
    }
}

