/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceRootNode
extends SliceNode {
    private final SliceUsage myRootUsage;

    public SliceRootNode(@NotNull Project project2, @NotNull DuplicateMap targetEqualUsages, @NotNull SliceUsage rootUsage) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceRootNode", "<init>"));
        }
        if (targetEqualUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetEqualUsages", "com/intellij/slicer/SliceRootNode", "<init>"));
        }
        if (rootUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootUsage", "com/intellij/slicer/SliceRootNode", "<init>"));
        }
        super(project2, LanguageSlicing.getProvider((PsiElement)rootUsage.getElement().getContainingFile()).createRootUsage((PsiElement)rootUsage.getElement().getContainingFile(), rootUsage.params), targetEqualUsages);
        this.myRootUsage = rootUsage;
    }

    private void switchToAllLeavesTogether(SliceUsage rootUsage) {
        SliceNode node = new SliceNode(this.getProject(), rootUsage, this.targetEqualUsages);
        this.myCachedChildren = Collections.singletonList(node);
    }

    @Override
    @NotNull
    SliceRootNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceRootNode newNode = new SliceRootNode(this.getProject(), new DuplicateMap(), newUsage);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        SliceRootNode sliceRootNode = newNode;
        if (sliceRootNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceRootNode", "copy"));
        }
        return sliceRootNode;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        if (this.myCachedChildren == null) {
            this.switchToAllLeavesTogether(this.myRootUsage);
        }
        List list = this.myCachedChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceRootNode", "getChildren"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends AbstractTreeNode> getChildrenUnderProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/slicer/SliceRootNode", "getChildrenUnderProgress"));
        }
        List list = (List)this.getChildren();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceRootNode", "getChildrenUnderProgress"));
        }
        return list;
    }

    @Override
    protected void update(PresentationData presentation) {
        if (presentation != null) {
            presentation.setChanged(presentation.isChanged() || this.changed);
            this.changed = false;
        }
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/slicer/SliceRootNode", "customizeCellRenderer"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/slicer/SliceRootNode", "customizeCellRenderer"));
        }
    }

    @NotNull
    SliceUsage getRootUsage() {
        SliceUsage sliceUsage = this.myRootUsage;
        if (sliceUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceRootNode", "getRootUsage"));
        }
        return sliceUsage;
    }
}

