/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSummary.ui;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.settingsSummary.ProblemType;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsSummaryDialog
extends DialogWrapper {
    private JTextArea summary;
    private JPanel centerPanel;
    private ComboBox<ProblemType> problemTypeBox;
    public static final ExtensionPointName<ProblemType> EP_SETTINGS = ExtensionPointName.create((String)"com.intellij.settingsSummaryFactory");

    public SettingsSummaryDialog(final Project project2) {
        super(project2);
        this.$$$setupUI$$$();
        this.setTitle("Settings Summary");
        for (ProblemType problemType : (ProblemType[])EP_SETTINGS.getExtensions()) {
            this.problemTypeBox.addItem((Object)problemType);
        }
        this.problemTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProblemType item = (ProblemType)e.getItem();
                SettingsSummaryDialog.this.summary.setText(item.collectInfo(project2));
            }
        });
        this.summary.setText(((ProblemType[])EP_SETTINGS.getExtensions())[0].collectInfo(project2));
        this.init();
        this.pack();
    }

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction copy = new DialogWrapper.DialogWrapperAction("&Copy"){

            protected void doAction(ActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(SettingsSummaryDialog.this.summary.getText()));
            }
        };
        Action[] actionArray = new Action[]{copy, this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/settingsSummary/ui/SettingsSummaryDialog", "createActions"));
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.centerPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JTextArea jTextArea;
        JPanel jPanel;
        this.centerPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JBScrollPane jBScrollPane = new JBScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jBScrollPane, gridBagConstraints);
        this.summary = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        this.problemTypeBox = comboBox = new ComboBox();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        jPanel.add((Component)comboBox, gridBagConstraints2);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Issue Type:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        jPanel.add((Component)jBLabel, gridBagConstraints3);
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setHorizontalTextPosition(2);
        jBLabel2.setText("The information may contain sensitive data");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.ipady = 10;
        jPanel.add((Component)jBLabel2, gridBagConstraints4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.centerPanel;
    }
}

