/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ReturnValueBeanBuilder {
    private final List<PsiTypeParameter> myTypeParams = new ArrayList<PsiTypeParameter>();
    private String myClassName;
    private String myPackageName;
    private Project myProject;
    private PsiType myValueType;
    private boolean myStatic;

    ReturnValueBeanBuilder() {
    }

    public void setClassName(String className) {
        this.myClassName = className;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = packageName;
    }

    public void setTypeArguments(List<PsiTypeParameter> typeParams) {
        this.myTypeParams.clear();
        this.myTypeParams.addAll(typeParams);
    }

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    public void setValueType(PsiType valueType) {
        this.myValueType = valueType;
    }

    public void setStatic(boolean isStatic) {
        this.myStatic = isStatic;
    }

    public String buildBeanClass() throws IOException {
        StringBuilder out = new StringBuilder(1024);
        if (this.myPackageName.length() > 0) {
            out.append("package ").append(this.myPackageName).append(";\n\n");
        }
        out.append("public ");
        if (this.myStatic) {
            out.append("static ");
        }
        out.append("class ").append(this.myClassName);
        if (!this.myTypeParams.isEmpty()) {
            out.append('<');
            boolean first = true;
            for (PsiTypeParameter typeParam : this.myTypeParams) {
                if (!first) {
                    out.append(',');
                }
                String parameterText = typeParam.getText();
                out.append(parameterText);
                first = false;
            }
            out.append('>');
        }
        out.append(" {\n");
        this.outputField(out);
        out.append("\n\n");
        this.outputConstructor(out);
        out.append("\n\n");
        this.outputGetter(out);
        out.append("\n}\n");
        return out.toString();
    }

    private void outputField(StringBuilder out) {
        String typeText = this.myValueType.getCanonicalText(false);
        out.append("\tprivate final ").append(typeText).append(' ').append(this.getFieldName("value")).append(";");
    }

    private void outputConstructor(StringBuilder out) {
        String typeText = this.myValueType.getCanonicalText(true);
        String name = "value";
        String parameterName = JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName("value", VariableKind.PARAMETER);
        String fieldName = this.getFieldName("value");
        out.append("\tpublic ").append(this.myClassName).append('(');
        out.append(CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS ? "final " : "");
        out.append(typeText).append(' ').append(parameterName);
        out.append(") {\n");
        if (fieldName.equals(parameterName)) {
            out.append("\t\tthis.").append(fieldName).append(" = ").append(parameterName).append(";\n");
        } else {
            out.append("\t\t").append(fieldName).append(" = ").append(parameterName).append(";\n");
        }
        out.append("\t}");
    }

    private void outputGetter(StringBuilder out) {
        String typeText = this.myValueType.getCanonicalText(true);
        String name = "value";
        String capitalizedName = StringUtil.capitalize((String)"value");
        String fieldName = this.getFieldName("value");
        out.append("\tpublic ").append(typeText).append(" get").append(capitalizedName).append("() {\n");
        out.append("\t\treturn ").append(fieldName).append(";\n");
        out.append("\t}");
    }

    private String getFieldName(String name) {
        return JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName(name, VariableKind.FIELD);
    }
}

