/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class VariableReturnValue
implements ReturnValue {
    private final PsiVariable myVariable;

    public VariableReturnValue(PsiVariable variable) {
        this.myVariable = variable;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof VariableReturnValue)) {
            return false;
        }
        return this.myVariable == ((VariableReturnValue)other).myVariable;
    }

    public PsiVariable getVariable() {
        return this.myVariable;
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)methodCallExpression.getProject());
        PsiDeclarationStatement statement2 = (PsiDeclarationStatement)styleManager.reformat((PsiElement)elementFactory.createVariableDeclarationStatement(this.myVariable.getName(), this.myVariable.getType(), (PsiExpression)methodCallExpression));
        ((PsiVariable)statement2.getDeclaredElements()[0]).getModifierList().replace((PsiElement)this.myVariable.getModifierList());
        return statement2;
    }
}

