/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import java.util.ArrayList;
import java.util.HashSet;

class TypeListCreatingVisitor
implements RefactoringHierarchyUtil.SuperTypeVisitor {
    private final ArrayList<PsiType> myList;
    private final PsiElementFactory myFactory;
    private final HashSet<PsiType> mySet;

    public TypeListCreatingVisitor(ArrayList<PsiType> result2, PsiElementFactory factory) {
        this.myList = result2;
        this.myFactory = factory;
        this.mySet = new HashSet();
    }

    @Override
    public void visitType(PsiType aType) {
        if (!this.mySet.contains(aType)) {
            this.myList.add(aType);
            this.mySet.add(aType);
        }
    }

    @Override
    public void visitClass(PsiClass aClass) {
        PsiClassType type = this.myFactory.createType(aClass);
        if (!this.mySet.contains(type)) {
            this.myList.add((PsiType)type);
            this.mySet.add((PsiType)type);
        }
    }
}

