/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class UnsafeUsagesDialog
extends DialogWrapper {
    private JEditorPane myMessagePane;
    private final String[] myConflictDescriptions;
    public static final int VIEW_USAGES_EXIT_CODE = 2;

    public UnsafeUsagesDialog(String[] conflictDescriptions, Project project2) {
        super(project2, true);
        this.myConflictDescriptions = conflictDescriptions;
        this.setTitle(RefactoringBundle.message((String)"usages.detected"));
        this.setOKButtonText(RefactoringBundle.message((String)"delete.anyway.button"));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        ViewUsagesAction viewUsagesAction = new ViewUsagesAction();
        Action ignoreAction = this.getOKAction();
        ignoreAction.putValue("DefaultAction", null);
        Action[] actionArray = new Action[]{viewUsagesAction, ignoreAction, new CancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/safeDelete/UnsafeUsagesDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myMessagePane = new JEditorPane("text/html", "");
        this.myMessagePane.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myMessagePane);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        panel2.add((Component)new JLabel(RefactoringBundle.message((String)"the.following.problems.were.found")), "North");
        panel2.add((Component)scrollPane, "Center");
        StringBuffer buf = new StringBuffer();
        for (String description : this.myConflictDescriptions) {
            buf.append(description);
            buf.append("<br><br>");
        }
        this.myMessagePane.setText(buf.toString());
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.safeDelete.UnsafeUsagesDialog";
    }

    private class ViewUsagesAction
    extends AbstractAction {
        public ViewUsagesAction() {
            super(RefactoringBundle.message((String)"view.usages"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UnsafeUsagesDialog.this.close(2);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(RefactoringBundle.message((String)"cancel.button"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UnsafeUsagesDialog.this.doCancelAction();
        }
    }
}

