/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(PsiMethod method2, String newName) {
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass != null) {
            PsiMethod[] overloads;
            for (PsiMethod overload : overloads = containingClass.findMethodsByName(method2.getName(), false)) {
                if (overload == method2 || overload.findDeepestSuperMethods().length != 0) continue;
                this.myElements.add(overload);
                this.suggestAllNames(overload.getName(), newName);
            }
        }
    }

    @Override
    public String getDialogTitle() {
        return "Rename Overloads";
    }

    @Override
    public String getDialogDescription() {
        return "Rename overloads to:";
    }

    @Override
    public String entityName() {
        return "Overload";
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }
}

