/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.MigrationUsagesViewDescriptor;
import com.intellij.refactoring.migration.MigrationUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MigrationProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationProcessor");
    private final MigrationMap myMigrationMap;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"migration.title");
    private PsiMigration myPsiMigration;

    public MigrationProcessor(Project project2, MigrationMap migrationMap) {
        super(project2);
        this.myMigrationMap = migrationMap;
        this.myPsiMigration = this.startMigration(project2);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/migration/MigrationProcessor", "createUsageViewDescriptor"));
        }
        MigrationUsagesViewDescriptor migrationUsagesViewDescriptor = new MigrationUsagesViewDescriptor(this.myMigrationMap, false);
        if (migrationUsagesViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/migration/MigrationProcessor", "createUsageViewDescriptor"));
        }
        return migrationUsagesViewDescriptor;
    }

    private PsiMigration startMigration(Project project2) {
        PsiMigration migration = PsiMigrationManager.getInstance(project2).startMigration();
        this.findOrCreateEntries(project2, migration);
        return migration;
    }

    private void findOrCreateEntries(Project project2, PsiMigration migration) {
        for (int i2 = 0; i2 < this.myMigrationMap.getEntryCount(); ++i2) {
            MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i2);
            if (entry.getType() == 0) {
                MigrationUtil.findOrCreatePackage(project2, migration, entry.getOldName());
                continue;
            }
            MigrationUtil.findOrCreateClass(project2, migration, entry.getOldName());
        }
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/migration/MigrationProcessor", "refreshElements"));
        }
        this.myPsiMigration = this.startMigration(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<MigrationUsageInfo> usagesVector = new ArrayList<MigrationUsageInfo>();
        try {
            if (this.myMigrationMap == null) {
                UsageInfo[] usageInfoArray = UsageInfo.EMPTY_ARRAY;
                if (usageInfoArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/migration/MigrationProcessor", "findUsages"));
                }
                return usageInfoArray;
            }
            for (int i2 = 0; i2 < this.myMigrationMap.getEntryCount(); ++i2) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i2);
                UsageInfo[] usages = entry.getType() == 0 ? MigrationUtil.findPackageUsages(this.myProject, this.myPsiMigration, entry.getOldName()) : MigrationUtil.findClassUsages(this.myProject, this.myPsiMigration, entry.getOldName());
                for (UsageInfo usage : usages) {
                    usagesVector.add(new MigrationUsageInfo(usage, entry));
                }
            }
        }
        finally {
            this.myPsiMigration.finish();
            this.myPsiMigration = null;
        }
        UsageInfo[] usageInfoArray = usagesVector.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/migration/MigrationProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/migration/MigrationProcessor", "preprocessUsages"));
        }
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)RefactoringBundle.message((String)"migration.no.usages.found.in.the.project"), (String)REFACTORING_NAME);
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/migration/MigrationProcessor", "performRefactoring"));
        }
        PsiMigration psiMigration = PsiMigrationManager.getInstance(this.myProject).startMigration();
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            for (int i2 = 0; i2 < this.myMigrationMap.getEntryCount(); ++i2) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i2);
                if (entry.getType() == 0) {
                    MigrationUtil.doPackageMigration(this.myProject, psiMigration, entry.getNewName(), usages);
                }
                if (entry.getType() != 1) continue;
                MigrationUtil.doClassMigration(this.myProject, psiMigration, entry.getNewName(), usages);
            }
            for (RefactoringHelper helper : (RefactoringHelper[])Extensions.getExtensions(RefactoringHelper.EP_NAME)) {
                Object preparedData = helper.prepareOperation(usages);
                helper.performOperation(this.myProject, preparedData);
            }
        }
        finally {
            a.finish();
            psiMigration.finish();
        }
    }

    @Override
    protected String getCommandName() {
        return REFACTORING_NAME;
    }

    static class MigrationUsageInfo
    extends UsageInfo {
        MigrationMapEntry mapEntry;

        MigrationUsageInfo(UsageInfo info, MigrationMapEntry mapEntry) {
            super(info.getElement(), info.getRangeInElement().getStartOffset(), info.getRangeInElement().getEndOffset());
            this.mapEntry = mapEntry;
        }
    }
}

