/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.PredefinedMigrationProvider;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class MigrationMapSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationMapSet");
    private ArrayList<MigrationMap> myMaps;
    @NonNls
    private static final String MIGRATION_MAP = "migrationMap";
    @NonNls
    private static final String ENTRY = "entry";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String OLD_NAME = "oldName";
    @NonNls
    private static final String NEW_NAME = "newName";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String TYPE = "type";
    @NonNls
    private static final String PACKAGE_TYPE = "package";
    @NonNls
    private static final String CLASS_TYPE = "class";
    @NonNls
    private static final String RECURSIVE = "recursive";
    @NonNls
    private static final String[] DEFAULT_MAPS = new String[]{"/com/intellij/refactoring/migration/res/Swing__1_0_3____1_1_.xml"};

    public void addMap(MigrationMap map) {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        this.myMaps.add(map);
    }

    public void replaceMap(MigrationMap oldMap, MigrationMap newMap) {
        for (int i2 = 0; i2 < this.myMaps.size(); ++i2) {
            if (this.myMaps.get(i2) != oldMap) continue;
            this.myMaps.set(i2, newMap);
        }
    }

    public void removeMap(MigrationMap map) {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        this.myMaps.remove(map);
    }

    public MigrationMap[] getMaps() {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        MigrationMap[] ret = new MigrationMap[this.myMaps.size()];
        for (int i2 = 0; i2 < this.myMaps.size(); ++i2) {
            ret[i2] = this.myMaps.get(i2);
        }
        return ret;
    }

    private static File getMapDirectory() {
        File dir = new File(PathManager.getConfigPath() + File.separator + "migration");
        if (!dir.exists()) {
            if (!dir.mkdir()) {
                LOG.error("cannot create directory: " + dir.getAbsolutePath());
                return null;
            }
            for (PredefinedMigrationProvider provider : (PredefinedMigrationProvider[])Extensions.getExtensions(PredefinedMigrationProvider.EP_NAME)) {
                URL migrationMap = provider.getMigrationMap();
                MigrationMapSet.copyMap(dir, migrationMap, new File(migrationMap.getFile()).getName());
            }
            for (String defaultTemplate : DEFAULT_MAPS) {
                URL url = MigrationMapSet.class.getResource(defaultTemplate);
                LOG.assertTrue(url != null);
                String fileName = defaultTemplate.substring(defaultTemplate.lastIndexOf("/") + 1);
                MigrationMapSet.copyMap(dir, url, fileName);
            }
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyMap(File dir, URL url, String fileName) {
        File targetFile = new File(dir, fileName);
        try {
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            InputStream inputStream = url.openStream();
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
                inputStream.close();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static File[] getMapFiles() {
        File dir = MigrationMapSet.getMapDirectory();
        if (dir == null) {
            return new File[0];
        }
        File[] ret = dir.listFiles(FileFilters.filesWithExtension((String)"xml"));
        if (ret == null) {
            LOG.error("cannot read directory: " + dir.getAbsolutePath());
            return new File[0];
        }
        return ret;
    }

    private void loadMaps() {
        this.myMaps = new ArrayList();
        File[] files = MigrationMapSet.getMapFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                MigrationMap map = MigrationMapSet.readMap(files[i2]);
                if (map == null) continue;
                this.myMaps.add(map);
                continue;
            }
            catch (InvalidDataException e) {
                LOG.error("Invalid data in file: " + files[i2].getAbsolutePath());
                continue;
            }
            catch (JDOMException e) {
                LOG.error("Invalid data in file: " + files[i2].getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static MigrationMap readMap(File file2) throws JDOMException, InvalidDataException, IOException {
        if (!file2.exists()) {
            return null;
        }
        Element root = JDOMUtil.load((File)file2);
        if (!MIGRATION_MAP.equals(root.getName())) {
            throw new InvalidDataException();
        }
        MigrationMap map = new MigrationMap();
        for (Element node : root.getChildren()) {
            if (NAME.equals(node.getName())) {
                String name = node.getAttributeValue(VALUE);
                map.setName(name);
            }
            if (DESCRIPTION.equals(node.getName())) {
                String description = node.getAttributeValue(VALUE);
                map.setDescription(description);
            }
            if (!ENTRY.equals(node.getName())) continue;
            MigrationMapEntry entry = new MigrationMapEntry();
            String oldName = node.getAttributeValue(OLD_NAME);
            if (oldName == null) {
                throw new InvalidDataException();
            }
            entry.setOldName(oldName);
            String newName = node.getAttributeValue(NEW_NAME);
            if (newName == null) {
                throw new InvalidDataException();
            }
            entry.setNewName(newName);
            String typeStr = node.getAttributeValue(TYPE);
            if (typeStr == null) {
                throw new InvalidDataException();
            }
            entry.setType(1);
            if (typeStr.equals(PACKAGE_TYPE)) {
                entry.setType(0);
                String isRecursiveStr = node.getAttributeValue(RECURSIVE);
                if (isRecursiveStr != null && isRecursiveStr.equals("true")) {
                    entry.setRecursive(true);
                } else {
                    entry.setRecursive(false);
                }
            }
            map.addEntry(entry);
        }
        return map;
    }

    public void saveMaps() throws IOException {
        File dir = MigrationMapSet.getMapDirectory();
        if (dir == null) {
            return;
        }
        File[] files = MigrationMapSet.getMapFiles();
        String[] filePaths = new String[this.myMaps.size()];
        Document[] documents = new Document[this.myMaps.size()];
        UniqueNameGenerator namesProvider = new UniqueNameGenerator();
        for (int i2 = 0; i2 < this.myMaps.size(); ++i2) {
            MigrationMap map = this.myMaps.get(i2);
            filePaths[i2] = dir + File.separator + namesProvider.generateUniqueName(FileUtil.sanitizeFileName((String)map.getName(), (boolean)false)) + ".xml";
            documents[i2] = MigrationMapSet.saveMap(map);
        }
        JDOMUtil.updateFileSet((File[])files, (String[])filePaths, (Document[])documents, (String)CodeStyleSettingsManager.getSettings(null).getLineSeparator());
    }

    private static Document saveMap(MigrationMap map) {
        Element root = new Element(MIGRATION_MAP);
        Element nameElement = new Element(NAME);
        nameElement.setAttribute(VALUE, map.getName());
        root.addContent(nameElement);
        Element descriptionElement = new Element(DESCRIPTION);
        descriptionElement.setAttribute(VALUE, map.getDescription());
        root.addContent(descriptionElement);
        for (int i2 = 0; i2 < map.getEntryCount(); ++i2) {
            MigrationMapEntry entry = map.getEntryAt(i2);
            Element element = new Element(ENTRY);
            element.setAttribute(OLD_NAME, entry.getOldName());
            element.setAttribute(NEW_NAME, entry.getNewName());
            if (entry.getType() == 0) {
                element.setAttribute(TYPE, PACKAGE_TYPE);
                element.setAttribute(RECURSIVE, Boolean.valueOf(entry.isRecursive()).toString());
            } else {
                element.setAttribute(TYPE, CLASS_TYPE);
            }
            root.addContent(element);
        }
        return new Document(root);
    }
}

