/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.AbstractInlineLocalDialog;

public class InlineLocalDialog
extends AbstractInlineLocalDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.variable.title");
    private final PsiVariable myVariable;
    private int myOccurrencesNumber = -1;

    public InlineLocalDialog(Project project2, PsiVariable variable, PsiJavaCodeReferenceElement ref, int occurrencesCount) {
        super(project2, (PsiElement)variable, (PsiReference)ref, occurrencesCount);
        this.myVariable = variable;
        this.myInvokedOnReference = ref != null;
        this.setTitle(REFACTORING_NAME);
        this.myOccurrencesNumber = occurrencesCount;
        this.init();
    }

    @Override
    protected String getNameLabelText() {
        return "Local variable " + this.myVariable.getName();
    }

    @Override
    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.variable");
    }

    @Override
    protected String getInlineAllText() {
        String occurrencesString = this.myOccurrencesNumber > -1 ? " (" + this.myOccurrencesNumber + " occurrence" + (this.myOccurrencesNumber == 1 ? ")" : "s)") : "";
        return RefactoringBundle.message((String)"all.references.and.remove.the.local") + occurrencesString;
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_LOCAL_THIS = this.isInlineThisOnly();
        }
        this.close(0);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.inlineVariable");
    }

    @Override
    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    @Override
    protected boolean hasPreviewButton() {
        return false;
    }
}

