/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ExceptionsTableModel;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterTableModel;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.JavaComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableColumnAnimator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureDialog
extends ChangeSignatureDialogBase<ParameterInfoImpl, PsiMethod, String, JavaMethodDescriptor, ParameterTableModelItemBase<ParameterInfoImpl>, JavaParameterTableModel> {
    private ExceptionsTableModel myExceptionsModel;
    protected Set<PsiMethod> myMethodsToPropagateExceptions;
    private AnActionButton myPropExceptionsButton;
    private Tree myExceptionPropagationTree;

    public JavaChangeSignatureDialog(Project project2, PsiMethod method2, boolean allowDelegation, PsiElement context) {
        this(project2, new JavaMethodDescriptor(method2), allowDelegation, context);
    }

    protected JavaChangeSignatureDialog(Project project2, JavaMethodDescriptor descriptor, boolean allowDelegation, PsiElement context) {
        super(project2, descriptor, allowDelegation, context);
    }

    public static JavaChangeSignatureDialog createAndPreselectNew(Project project2, PsiMethod method2, final List<ParameterInfoImpl> parameterInfos, boolean allowDelegation, PsiReferenceExpression refExpr) {
        return new JavaChangeSignatureDialog(project2, method2, allowDelegation, (PsiElement)refExpr){

            @Override
            protected int getSelectedIdx() {
                for (int i2 = 0; i2 < parameterInfos.size(); ++i2) {
                    ParameterInfoImpl info = (ParameterInfoImpl)parameterInfos.get(i2);
                    if (info.oldParameterIndex >= 0) continue;
                    return i2;
                }
                return super.getSelectedIdx();
            }
        };
    }

    @Override
    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new JavaComboBoxVisibilityPanel();
    }

    @Override
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        this.myPropagateParamChangesButton.setVisible(true);
        return centerPanel;
    }

    @Override
    protected void updatePropagateButtons() {
        super.updatePropagateButtons();
        this.myPropExceptionsButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateExceptions());
    }

    protected boolean mayPropagateExceptions() {
        PsiClassType[] types;
        ThrownExceptionInfo[] exceptions = this.myExceptionsModel.getThrownExceptions();
        if (exceptions.length <= (types = ((JavaMethodDescriptor)this.myMethod).getMethod().getThrowsList().getReferencedTypes()).length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (exceptions[i2].getOldIndex() == i2) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected List<Pair<String, JPanel>> createAdditionalPanels() {
        this.myExceptionsModel = new ExceptionsTableModel((PsiElement)((JavaMethodDescriptor)this.myMethod).getMethod().getThrowsList());
        this.myExceptionsModel.setTypeInfos(((JavaMethodDescriptor)this.myMethod).getMethod());
        final JBTable table = new JBTable((TableModel)this.myExceptionsModel);
        table.setStriped(true);
        table.setRowHeight(20);
        table.getColumnModel().getColumn(0).setCellRenderer(new CodeFragmentTableCellRenderer(this.myProject));
        final JavaCodeFragmentTableCellEditor cellEditor = new JavaCodeFragmentTableCellEditor(this.myProject);
        cellEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                int row = table.getSelectedRow();
                int col = table.getSelectedColumn();
                JavaChangeSignatureDialog.this.myExceptionsModel.setValueAt(cellEditor.getCellEditorValue(), row, col);
                JavaChangeSignatureDialog.this.updateSignature();
            }
        });
        table.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().setSelectionInterval(0, 0);
        table.setSurrendersFocusOnKeystroke(true);
        this.myPropExceptionsButton = new AnActionButton(RefactoringBundle.message((String)"changeSignature.propagate.exceptions.title"), null, AllIcons.Hierarchy.Caller){

            public void actionPerformed(AnActionEvent e) {
                Ref chooser = new Ref();
                Consumer callback = psiMethods -> {
                    JavaChangeSignatureDialog.this.myMethodsToPropagateExceptions = psiMethods;
                    JavaChangeSignatureDialog.this.myExceptionPropagationTree = ((JavaCallerChooser)((Object)((Object)chooser.get()))).getTree();
                };
                chooser.set((Object)new JavaCallerChooser(((JavaMethodDescriptor)JavaChangeSignatureDialog.this.myMethod).getMethod(), JavaChangeSignatureDialog.this.myProject, RefactoringBundle.message((String)"changeSignature.exception.caller.chooser"), JavaChangeSignatureDialog.this.myExceptionPropagationTree, (Consumer<Set<PsiMethod>>)callback));
                ((JavaCallerChooser)((Object)chooser.get())).show();
            }
        };
        this.myPropExceptionsButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt X"}));
        JPanel panel2 = ToolbarDecorator.createDecorator((JTable)table).addExtraAction(this.myPropExceptionsButton).createPanel();
        panel2.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myExceptionsModel.addTableModelListener(this.mySignatureUpdater);
        ArrayList<Pair<String, JPanel>> result2 = new ArrayList<Pair<String, JPanel>>();
        String message = RefactoringBundle.message((String)"changeSignature.exceptions.panel.border.title");
        result2.add(Pair.create((Object)message, (Object)panel2));
        ArrayList<Pair<String, JPanel>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog", "createAdditionalPanels"));
        }
        return arrayList;
    }

    @Override
    protected LanguageFileType getFileType() {
        return StdFileTypes.JAVA;
    }

    @Override
    protected JavaParameterTableModel createParametersInfoModel(JavaMethodDescriptor descriptor) {
        PsiParameterList parameterList = descriptor.getMethod().getParameterList();
        return new JavaParameterTableModel((PsiElement)parameterList, this.myDefaultValueContext, this);
    }

    @Override
    protected boolean isListTableViewSupported() {
        return true;
    }

    @Override
    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(){
            private final EditorTextFieldJBTableRowRenderer myRowRenderer;
            {
                this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType(), JavaChangeSignatureDialog.this.myDisposable){

                    @Override
                    protected String getText(JTable table, int row) {
                        Object item = this.getRowItem(row);
                        String typeText = ((ParameterTableModelItemBase)item).typeCodeFragment.getText();
                        String separator = StringUtil.repeatSymbol((char)' ', (int)(JavaChangeSignatureDialog.this.getTypesMaxLength() - typeText.length() + 1));
                        String text = typeText + separator + ((ParameterInfoImpl)((ParameterTableModelItemBase)item).parameter).getName();
                        String defaultValue = ((ParameterTableModelItemBase)item).defaultValueCodeFragment.getText();
                        String tail = "";
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            tail = tail + " default value = " + defaultValue;
                        }
                        if (((ParameterInfoImpl)((ParameterTableModelItemBase)item).parameter).isUseAnySingleVariable()) {
                            if (StringUtil.isNotEmpty((String)defaultValue)) {
                                tail = tail + ";";
                            }
                            tail = tail + " Use any var.";
                        }
                        if (!StringUtil.isEmpty((String)tail)) {
                            text = text + " //" + tail;
                        }
                        return " " + text;
                    }
                };
            }

            @Override
            protected JBTableRowRenderer getRowRenderer(int row) {
                return this.myRowRenderer;
            }

            @NotNull
            protected JBTableRowEditor getRowEditor(final ParameterTableModelItemBase<ParameterInfoImpl> item) {
                JBTableRowEditor jBTableRowEditor = new JBTableRowEditor(){
                    private EditorTextField myTypeEditor;
                    private EditorTextField myNameEditor;
                    private EditorTextField myDefaultValueEditor;
                    private JCheckBox myAnyVar;

                    @Override
                    public void prepareEditor(JTable table, int row) {
                        this.setLayout(new BorderLayout());
                        Document document = PsiDocumentManager.getInstance((Project)JavaChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.typeCodeFragment);
                        this.myTypeEditor = new EditorTextField(document, JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType());
                        this.myTypeEditor.addDocumentListener(JavaChangeSignatureDialog.this.mySignatureUpdater);
                        this.myTypeEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                        this.myTypeEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener(0));
                        this.add((Component)2.createLabeledPanel("Type:", (JComponent)((Object)this.myTypeEditor)), "West");
                        this.myNameEditor = new EditorTextField(((ParameterInfoImpl)item.parameter).getName(), JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType());
                        this.myNameEditor.addDocumentListener(JavaChangeSignatureDialog.this.mySignatureUpdater);
                        this.myNameEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener(1));
                        this.add((Component)2.createLabeledPanel("Name:", (JComponent)((Object)this.myNameEditor)), "Center");
                        new TextFieldCompletionProvider(){

                            @Override
                            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                                if (text == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$4$2$1", "addCompletionVariants"));
                                }
                                if (prefix == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$4$2$1", "addCompletionVariants"));
                                }
                                if (result2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$4$2$1", "addCompletionVariants"));
                                }
                                PsiCodeFragment fragment = item.typeCodeFragment;
                                if (fragment instanceof PsiTypeCodeFragment) {
                                    PsiType type;
                                    try {
                                        type = ((PsiTypeCodeFragment)fragment).getType();
                                    }
                                    catch (Exception e) {
                                        return;
                                    }
                                    SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)JavaChangeSignatureDialog.this.myProject).suggestVariableName(VariableKind.PARAMETER, null, null, type);
                                    for (String completionVariant : info.names) {
                                        LookupElementBuilder element = LookupElementBuilder.create((String)completionVariant);
                                        result2.addElement((LookupElement)element.withLookupString(completionVariant.toLowerCase(Locale.ENGLISH)));
                                    }
                                }
                            }
                        }.apply(this.myNameEditor, ((ParameterInfoImpl)item.parameter).getName());
                        if (!item.isEllipsisType() && ((ParameterInfoImpl)item.parameter).getOldIndex() == -1) {
                            JPanel additionalPanel = new JPanel(new BorderLayout());
                            Document doc = PsiDocumentManager.getInstance((Project)JavaChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.defaultValueCodeFragment);
                            this.myDefaultValueEditor = new EditorTextField(doc, JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType());
                            ((PsiExpressionCodeFragment)item.defaultValueCodeFragment).setExpectedType(JavaChangeSignatureDialog.getRowType(item));
                            this.myDefaultValueEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                            this.myDefaultValueEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener(2));
                            additionalPanel.add((Component)2.createLabeledPanel("Default value:", (JComponent)((Object)this.myDefaultValueEditor)), "West");
                            if (!JavaChangeSignatureDialog.this.isGenerateDelegate()) {
                                this.myAnyVar = new JCheckBox("&Use Any Var");
                                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myAnyVar);
                                DialogUtil.registerMnemonic((AbstractButton)this.myAnyVar, (char)'&');
                                this.myAnyVar.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ((ParameterInfoImpl)item.parameter).setUseAnySingleVariable(myAnyVar.isSelected());
                                    }
                                });
                                JPanel anyVarPanel = new JPanel(new BorderLayout());
                                anyVarPanel.add((Component)this.myAnyVar, "South");
                                UIUtil.addInsets((JComponent)anyVarPanel, (Insets)JBUI.insetsBottom((int)8));
                                additionalPanel.add((Component)anyVarPanel, "Center");
                            }
                            this.add((Component)additionalPanel, "South");
                        }
                    }

                    @Override
                    public JBTableRow getValue() {
                        return new JBTableRow(){

                            @Override
                            public Object getValueAt(int column) {
                                switch (column) {
                                    case 0: {
                                        return item.typeCodeFragment;
                                    }
                                    case 1: {
                                        return myNameEditor.getText().trim();
                                    }
                                    case 2: {
                                        return item.defaultValueCodeFragment;
                                    }
                                    case 3: {
                                        return myAnyVar != null && myAnyVar.isSelected();
                                    }
                                }
                                return null;
                            }
                        };
                    }

                    @Override
                    public JComponent getPreferredFocusedComponent() {
                        MouseEvent me = this.getMouseEvent();
                        if (me == null) {
                            return this.myTypeEditor.getFocusTarget();
                        }
                        double x = me.getPoint().getX();
                        return x <= (double)JavaChangeSignatureDialog.this.getTypesColumnWidth() ? this.myTypeEditor.getFocusTarget() : (this.myDefaultValueEditor == null || x <= (double)JavaChangeSignatureDialog.this.getNamesColumnWidth() ? this.myNameEditor.getFocusTarget() : this.myDefaultValueEditor.getFocusTarget());
                    }

                    @Override
                    public JComponent[] getFocusableComponents() {
                        ArrayList<JComponent> focusable = new ArrayList<JComponent>();
                        focusable.add(this.myTypeEditor.getFocusTarget());
                        focusable.add(this.myNameEditor.getFocusTarget());
                        if (this.myDefaultValueEditor != null) {
                            focusable.add(this.myDefaultValueEditor.getFocusTarget());
                        }
                        if (this.myAnyVar != null) {
                            focusable.add(this.myAnyVar);
                        }
                        return focusable.toArray(new JComponent[focusable.size()]);
                    }
                };
                if (jBTableRowEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$4", "getRowEditor"));
                }
                return jBTableRowEditor;
            }

            @Override
            protected boolean isRowEmpty(int row) {
                ParameterInfoImpl parameter = (ParameterInfoImpl)((ParameterTableModelItemBase)this.getRowItem((int)row)).parameter;
                return StringUtil.isEmpty((String)parameter.getName()) && StringUtil.isEmpty((String)parameter.getTypeText());
            }
        };
    }

    private int getTypesMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((JavaParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = item.typeCodeFragment == null ? null : item.typeCodeFragment.getText();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    private int getNamesMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((JavaParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = ((ParameterInfoImpl)item.parameter).getName();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    private int getColumnWidth(int index) {
        int letters = this.getTypesMaxLength() + (index == 0 ? 1 : this.getNamesMaxLength() + 2);
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        return letters * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
    }

    private int getTypesColumnWidth() {
        return this.getColumnWidth(0);
    }

    private int getNamesColumnWidth() {
        return this.getColumnWidth(1);
    }

    @Nullable
    private static PsiType getRowType(ParameterTableModelItemBase<ParameterInfoImpl> item) {
        try {
            return ((PsiTypeCodeFragment)item.typeCodeFragment).getType();
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            return null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            return null;
        }
    }

    @Override
    protected void customizeParametersTable(TableView<ParameterTableModelItemBase<ParameterInfoImpl>> table) {
        final JTable t = table.getComponent();
        final TableColumn defaultValue = t.getColumnModel().getColumn(2);
        final TableColumn varArg = t.getColumnModel().getColumn(3);
        t.removeColumn(defaultValue);
        t.removeColumn(varArg);
        t.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    t.getModel().removeTableModelListener(this);
                    TableColumnAnimator animator = new TableColumnAnimator(t);
                    animator.setStep(48);
                    animator.addColumn(defaultValue, (t.getWidth() - 48) / 3);
                    animator.addColumn(varArg, 48);
                    animator.startAndDoWhenDone(() -> t.editCellAt(t.getRowCount() - 1, 0));
                    animator.start();
                }
            }
        });
    }

    @Override
    protected void invokeRefactoring(BaseRefactoringProcessor processor2) {
        if (this.myMethodsToPropagateExceptions != null && !this.mayPropagateExceptions()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.exceptions.wont.propagate"), (String)ChangeSignatureHandler.REFACTORING_NAME);
            this.myMethodsToPropagateExceptions = null;
        }
        super.invokeRefactoring(processor2);
    }

    @Override
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        List parameters = this.getParameters();
        return new ChangeSignatureProcessor(this.myProject, ((JavaMethodDescriptor)this.myMethod).getMethod(), this.isGenerateDelegate(), (String)this.getVisibility(), this.getMethodName(), this.getReturnType(), parameters.toArray(new ParameterInfoImpl[parameters.size()]), this.getExceptions(), this.myMethodsToPropagateParameters, this.myMethodsToPropagateExceptions);
    }

    @Nullable
    protected CanonicalTypes.Type getReturnType() {
        if (this.myReturnTypeField != null) {
            try {
                PsiType type = ((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType();
                return CanonicalTypes.createTypeWrapper(type);
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return null;
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return null;
            }
        }
        return null;
    }

    protected ThrownExceptionInfo[] getExceptions() {
        return this.myExceptionsModel.getThrownExceptions();
    }

    @Override
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        String returnTypeText = StringUtil.notNullize((String)((JavaMethodDescriptor)this.myMethod).getReturnTypeText());
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
        return factory.createTypeCodeFragment(returnTypeText, (PsiElement)((JavaMethodDescriptor)this.myMethod).getMethod(), true, 1);
    }

    @Override
    protected CallerChooserBase<PsiMethod> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<PsiMethod>> callback) {
        return new JavaCallerChooser(((JavaMethodDescriptor)this.myMethod).getMethod(), this.myProject, title, treeToReuse, callback);
    }

    @Override
    protected String validateAndCommitData() {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String name = this.getMethodName();
        if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(name)) {
            return RefactoringMessageUtil.getIncorrectIdentifierMessage(name);
        }
        if (((JavaMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            try {
                ((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType();
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                this.myReturnTypeField.requestFocus();
                return RefactoringBundle.message((String)"changeSignature.wrong.return.type", (Object[])new Object[]{this.myReturnTypeCodeFragment.getText()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                this.myReturnTypeField.requestFocus();
                return RefactoringBundle.message((String)"changeSignature.no.return.type");
            }
        }
        List parameterInfos = ((JavaParameterTableModel)this.myParametersTableModel).getItems();
        int newParametersNumber = parameterInfos.size();
        for (int i2 = 0; i2 < newParametersNumber; ++i2) {
            String def;
            PsiType type;
            final ParameterTableModelItemBase item = (ParameterTableModelItemBase)parameterInfos.get(i2);
            if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(((ParameterInfoImpl)item.parameter).getName())) {
                return RefactoringMessageUtil.getIncorrectIdentifierMessage(((ParameterInfoImpl)item.parameter).getName());
            }
            try {
                type = ((PsiTypeCodeFragment)((ParameterTableModelItemBase)parameterInfos.get((int)i2)).typeCodeFragment).getType();
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeSignature.wrong.type.for.parameter", (Object[])new Object[]{item.typeCodeFragment.getText(), ((ParameterInfoImpl)item.parameter).getName()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{"return", ((ParameterInfoImpl)item.parameter).getName()});
            }
            ((ParameterInfoImpl)item.parameter).setType(type);
            if (type instanceof PsiEllipsisType && i2 != newParametersNumber - 1) {
                return RefactoringBundle.message((String)"changeSignature.vararg.not.last");
            }
            if (((ParameterInfoImpl)item.parameter).oldParameterIndex >= 0) continue;
            ((ParameterInfoImpl)item.parameter).defaultValue = def = (String)WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Computable)new Computable<String>(){

                public String compute() {
                    return JavaCodeStyleManager.getInstance((Project)JavaChangeSignatureDialog.this.myProject).qualifyClassReferences((PsiElement)item.defaultValueCodeFragment).getText().trim();
                }
            });
            if (type instanceof PsiEllipsisType) continue;
            try {
                if (StringUtil.isEmpty((String)def)) continue;
                factory.createExpressionFromText(def, null);
                continue;
            }
            catch (IncorrectOperationException e) {
                return e.getMessage();
            }
        }
        ThrownExceptionInfo[] exceptionInfos = this.myExceptionsModel.getThrownExceptions();
        PsiTypeCodeFragment[] typeCodeFragments = this.myExceptionsModel.getTypeCodeFragments();
        for (int i3 = 0; i3 < exceptionInfos.length; ++i3) {
            ThrownExceptionInfo exceptionInfo = exceptionInfos[i3];
            PsiTypeCodeFragment typeCodeFragment = typeCodeFragments[i3];
            try {
                PsiType type = typeCodeFragment.getType();
                if (!(type instanceof PsiClassType)) {
                    return RefactoringBundle.message((String)"changeSignature.wrong.type.for.exception", (Object[])new Object[]{typeCodeFragment.getText()});
                }
                PsiClassType throwable = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createTypeByFQClassName("java.lang.Throwable", type.getResolveScope());
                if (!throwable.isAssignableFrom(type)) {
                    return RefactoringBundle.message((String)"changeSignature.not.throwable.type", (Object[])new Object[]{typeCodeFragment.getText()});
                }
                exceptionInfo.setType((PsiClassType)type);
                continue;
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeSignature.wrong.type.for.exception", (Object[])new Object[]{typeCodeFragment.getText()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.exception");
            }
        }
        try {
            if (((JavaMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && !RefactoringUtil.isResolvableType(((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType()) && Messages.showOkCancelDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.return.type", (Object[])new Object[]{this.myReturnTypeCodeFragment.getText()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getWarningIcon()) != 0) {
                return "";
            }
            for (ParameterTableModelItemBase item : parameterInfos) {
                if (RefactoringUtil.isResolvableType(((PsiTypeCodeFragment)item.typeCodeFragment).getType()) || Messages.showOkCancelDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.parameter.type", (Object[])new Object[]{item.typeCodeFragment.getText(), ((ParameterInfoImpl)item.parameter).getName()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getWarningIcon()) == 0) continue;
                return "";
            }
        }
        catch (PsiTypeCodeFragment.IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        return null;
    }

    protected ValidationInfo doValidate() {
        if (!this.getTableComponent().isEditing()) {
            for (ParameterTableModelItemBase item : ((JavaParameterTableModel)this.myParametersTableModel).getItems()) {
                if (((ParameterInfoImpl)item.parameter).oldParameterIndex >= 0 || !StringUtil.isEmpty((String)item.defaultValueCodeFragment.getText())) continue;
                return new ValidationInfo("Default value is missing. Method calls will contain blanks instead of the new parameter value.");
            }
        }
        return super.doValidate();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Override
    protected String calculateSignature() {
        return this.doCalculateSignature(((JavaMethodDescriptor)this.myMethod).getMethod());
    }

    protected String doCalculateSignature(PsiMethod method2) {
        String text;
        StringBuilder buffer = new StringBuilder();
        PsiModifierList modifierList = method2.getModifierList();
        String modifiers = modifierList.getText();
        String oldModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
        String newModifier = (String)ObjectUtils.notNull(this.getVisibility(), (Object)"packageLocal");
        String newModifierStr = VisibilityUtil.getVisibilityString((String)newModifier);
        if (!Comparing.equal((String)newModifier, (String)oldModifier)) {
            int index = modifiers.indexOf(oldModifier);
            if (index >= 0) {
                StringBuilder buf = new StringBuilder(modifiers);
                buf.replace(index, index + oldModifier.length() + (StringUtil.isEmpty((String)newModifierStr) ? 1 : 0), newModifierStr);
                modifiers = buf.toString();
            } else {
                if (!StringUtil.isEmpty((String)newModifierStr)) {
                    newModifierStr = newModifierStr + " ";
                }
                modifiers = newModifierStr + modifiers;
            }
        }
        buffer.append(modifiers);
        if (!(modifiers.length() <= 0 || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\n') || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\r') || StringUtil.endsWithChar((CharSequence)modifiers, (char)' '))) {
            buffer.append(" ");
        }
        if (!method2.isConstructor()) {
            CanonicalTypes.Type type = this.getReturnType();
            if (type != null) {
                buffer.append(type.getTypeText());
            }
            buffer.append(" ");
        }
        buffer.append(this.getMethodName());
        buffer.append("(");
        int lineBreakIdx = buffer.lastIndexOf("\n");
        String indent = StringUtil.repeatSymbol((char)' ', (int)(lineBreakIdx >= 0 ? buffer.length() - lineBreakIdx - 1 : buffer.length()));
        List items = ((JavaParameterTableModel)this.myParametersTableModel).getItems();
        int curIndent = indent.length();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)items.get(i2);
            if (i2 > 0) {
                buffer.append(",");
                buffer.append("\n");
                buffer.append(indent);
            }
            text = item.typeCodeFragment.getText();
            buffer.append(text).append(" ");
            String name = ((ParameterInfoImpl)item.parameter).getName();
            buffer.append(name);
            curIndent = indent.length() + text.length() + 1 + name.length();
        }
        buffer.append(")");
        PsiTypeCodeFragment[] thrownExceptionsFragments = this.myExceptionsModel.getTypeCodeFragments();
        if (thrownExceptionsFragments.length > 0) {
            buffer.append(" throws ");
            indent = StringUtil.repeatSymbol((char)' ', (int)(curIndent += 9));
            for (int i3 = 0; i3 < thrownExceptionsFragments.length; ++i3) {
                text = thrownExceptionsFragments[i3].getText();
                if (i3 != 0) {
                    buffer.append(indent);
                }
                buffer.append(text);
                if (i3 < thrownExceptionsFragments.length - 1) {
                    buffer.append(",");
                }
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

