/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl.test;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubsHierarchy.ClassHierarchy;
import com.intellij.psi.stubsHierarchy.HierarchyService;
import com.intellij.psi.stubsHierarchy.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.test.InheritanceAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStubHierarchyAction
extends InheritanceAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubsHierarchy.TestStubHierarchyAction");

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(new TestHierarchy(project2)::run), "Testing Hierarchy", true, project2);
        }
    }

    private static class TestHierarchy
    implements Runnable {
        private final Project myProject;

        TestHierarchy(Project project2) {
            this.myProject = project2;
        }

        @Override
        public void run() {
            LOG.info("TestStubHierarchyAction started");
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            HierarchyService service = HierarchyService.getService(this.myProject);
            service.clearHierarchy();
            indicator.setText("Building hierarchy");
            ClassHierarchy hierarchy = service.getHierarchy();
            MultiMap<SmartClassAnchor, SmartClassAnchor> supers = this.calcSupersMap(hierarchy);
            indicator.setText("Checking");
            this.compareSupers(indicator, supers, hierarchy);
            LOG.info("TestStubHierarchyAction finished");
        }

        private void compareSupers(ProgressIndicator indicator, MultiMap<SmartClassAnchor, SmartClassAnchor> supers, ClassHierarchy hierarchy) {
            List<VirtualFile> covered = this.getCoveredFiles(indicator, hierarchy);
            for (int i2 = 0; i2 < covered.size(); ++i2) {
                indicator.setFraction((double)i2 * 1.0 / (double)covered.size());
                this.checkFile(supers, hierarchy, covered.get(i2));
            }
        }

        private void checkFile(MultiMap<SmartClassAnchor, SmartClassAnchor> supers, ClassHierarchy hierarchy, VirtualFile vFile) {
            for (StubElement<?> element : this.getStubTree(vFile).getPlainListFromAllRoots()) {
                PsiElement psi = element.getPsi();
                if (!(psi instanceof PsiClass) || psi instanceof PsiTypeParameter) continue;
                SmartClassAnchor anchor = hierarchy.findAnchor((PsiClass)psi);
                if (anchor == null) {
                    throw new AssertionError((Object)("Class not indexed: " + psi + " in " + vFile));
                }
                this.compareSupers(anchor, supers.get((Object)anchor));
            }
        }

        @NotNull
        private List<VirtualFile> getCoveredFiles(ProgressIndicator indicator, ClassHierarchy hierarchy) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
            GlobalSearchScope uncovered = hierarchy.restrictToUncovered(allScope);
            ArrayList<VirtualFile> covered = new ArrayList<VirtualFile>();
            FileBasedIndex.getInstance().iterateIndexableFiles(file2 -> {
                if (!file2.isDirectory() && allScope.contains(file2) && !uncovered.contains(file2)) {
                    covered.add(file2);
                }
                return true;
            }, this.myProject, indicator);
            ArrayList<VirtualFile> arrayList = covered;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/test/TestStubHierarchyAction$TestHierarchy", "getCoveredFiles"));
            }
            return arrayList;
        }

        @NotNull
        private StubTree getStubTree(VirtualFile vFile) {
            PsiFileWithStubSupport psiFile = (PsiFileWithStubSupport)PsiManager.getInstance((Project)this.myProject).findFile(vFile);
            assert (psiFile != null) : "No PSI for " + vFile;
            StubTree stubTree = psiFile.getStubTree();
            StubTree stubTree2 = stubTree != null ? stubTree : ((PsiFileImpl)psiFile).calcStubTree();
            if (stubTree2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/test/TestStubHierarchyAction$TestHierarchy", "getStubTree"));
            }
            return stubTree2;
        }

        private void compareSupers(SmartClassAnchor anchor, Collection<SmartClassAnchor> superAnchors) {
            PsiClass subClass = anchor.retrieveClass(this.myProject);
            List stubSuperList = ContainerUtil.map(superAnchors, anchor1 -> anchor1.retrieveClass(this.myProject));
            HashSet psiSupers = new HashSet(ContainerUtil.filter(TestHierarchy.getPsiSupers(subClass), psiClass -> !TestHierarchy.isImplicit(psiClass.getQualifiedName())));
            HashSet stubSupers = new HashSet(ContainerUtil.filter((Collection)stubSuperList, psiClass -> !TestHierarchy.isImplicit(psiClass.getQualifiedName())));
            if (!stubSupers.containsAll(psiSupers)) {
                psiSupers.removeAll(stubSupers);
                throw new AssertionError((Object)("Inconsistent hierarchy for " + TestHierarchy.classInfo(subClass) + "\n  missing " + psiSupers.size() + ": " + StringUtil.join(psiSupers, TestHierarchy::classInfo, (String)", ")));
            }
        }

        @NotNull
        private static List<PsiClass> getPsiSupers(PsiClass subClass) {
            ArrayList<PsiClass> psiSupers = new ArrayList<PsiClass>();
            PsiClass superClass = subClass.getSuperClass();
            ContainerUtil.addIfNotNull(psiSupers, (Object)superClass);
            Collections.addAll(psiSupers, subClass.getInterfaces());
            ArrayList<PsiClass> arrayList = psiSupers;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/test/TestStubHierarchyAction$TestHierarchy", "getPsiSupers"));
            }
            return arrayList;
        }

        private static boolean isImplicit(@Nullable String qname) {
            return "java.lang.Object".equals(qname) || "groovy.lang.GroovyObject".equals(qname) || "groovy.lang.GroovyObjectSupport".equals(qname);
        }

        @NotNull
        MultiMap<SmartClassAnchor, SmartClassAnchor> calcSupersMap(ClassHierarchy hierarchy) {
            MultiMap supers = MultiMap.create();
            for (SmartClassAnchor smartClassAnchor : hierarchy.getAllClasses()) {
                for (SmartClassAnchor subtype : hierarchy.getDirectSubtypeCandidates(smartClassAnchor)) {
                    supers.putValue((Object)subtype, (Object)smartClassAnchor);
                }
            }
            MultiMap multiMap = supers;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/test/TestStubHierarchyAction$TestHierarchy", "calcSupersMap"));
            }
            return multiMap;
        }

        @NotNull
        private static String classInfo(PsiClass psiClass) {
            String name = psiClass.getQualifiedName();
            if (name == null) {
                name = psiClass.toString();
            }
            String string = name + " (" + psiClass.getContainingFile().getVirtualFile().getPresentableUrl() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/test/TestStubHierarchyAction$TestHierarchy", "classInfo"));
            }
            return string;
        }
    }
}

