/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final MyInputFilter myInputFilter = new MyInputFilter();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = this.myDataIndexer;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        MyInputFilter myInputFilter = this.myInputFilter;
        if (myInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getInputFilter"));
        }
        return myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public boolean indexDirectories() {
        return true;
    }

    public int getVersion() {
        return 1 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    public static String[] getAllFilenames(Project project2) {
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(NAME, project2);
        return ArrayUtil.toStringArray((Collection)allKeys);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)name, scope);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project2, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, null);
    }

    public static PsiFile[] getFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project2, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        return FilenameIndex.processFilesByName(name, includeDirs, true, processor2, scope, project2, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        Object files;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (caseSensitively) {
            files = new THashSet();
            FileBasedIndex.getInstance().processValues(NAME, (Object)name, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>((Set)files){
                final /* synthetic */ Set val$files;
                {
                    this.val$files = set2;
                }

                public boolean process(VirtualFile file2, Void value) {
                    this.val$files.add(file2);
                    return true;
                }
            }, scope, idFilter);
        } else {
            files = FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, idFilter);
        }
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        int processedFiles = 0;
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            PsiDirectory dir;
            VirtualFile file2 = (VirtualFile)iterator.next();
            if (!file2.isValid()) continue;
            if (!includeDirs && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        THashSet keys = new THashSet();
        FileBasedIndex index = FileBasedIndex.getInstance();
        index.processAllKeys(NAME, arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$0(name, (Set)keys, arg_0), scope, idFilter);
        THashSet files = new THashSet();
        for (String each : keys) {
            files.addAll(index.getContainingFiles(NAME, (Object)each, scope));
        }
        THashSet tHashSet = files;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        return tHashSet;
    }

    public static PsiFileSystemItem[] getFilesByName(Project project2, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name, includeDirs, (Processor<? super PsiFileSystemItem>)processor2, scope, project2, null);
        if (includeDirs) {
            return (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result2, PsiFileSystemItem.class);
        }
        return (PsiFileSystemItem[])result2.toArray((Object[])new PsiFile[result2.size()]);
    }

    public static void processAllFileNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, @NotNull IdFilter filter) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processAllFileNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processAllFileNames"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/search/FilenameIndex", "processAllFileNames"));
        }
        FileBasedIndex.getInstance().processAllKeys(NAME, processor2, scope, filter);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project2, ext, GlobalSearchScope.allScope((Project)project2));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        int len = ext.length();
        if (len == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
            }
            return list;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project2)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project2, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return arrayList;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$0(@NotNull String name, Set keys, String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "lambda$getVirtualFilesByNameIgnoringCase$0"));
        }
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        public boolean acceptInput(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/FilenameIndex$MyInputFilter", "acceptInput"));
            }
            return true;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/search/FilenameIndex$MyDataIndexer", "map"));
            }
            Map<String, Object> map = Collections.singletonMap(inputData.getFileName(), null);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

