/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list, @NotNull LanguageLevel languageLevel) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this((PsiElement)list, null, languageLevel);
    }

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel) {
        if (argumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsList", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public final CandidateInfo resolveConflict(final @NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "resolveConflict"));
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)this.myArgumentsList);
        if (properties != null && properties.isApplicabilityCheck()) {
            PsiMethod method2 = properties.getMethod();
            LOG.error("Recursive conflict resolution for:" + method2 + "; " + this.myArgumentsList.getText() + "; file=" + (method2 == null ? "<unknown>" : method2.getContainingFile()));
        }
        return (CandidateInfo)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)this.myArgumentsList, false, (Computable)new Computable<CandidateInfo>(){

            public CandidateInfo compute() {
                return JavaMethodsConflictResolver.this.guardedOverloadResolution(conflicts);
            }
        });
    }

    @Nullable
    protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "guardedOverloadResolution"));
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        boolean atLeastOneMatch = this.checkParametersNumber(conflicts, this.getActualParametersLength(), true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        FactoryMap<MethodCandidateInfo, PsiSubstitutor> map = new FactoryMap<MethodCandidateInfo, PsiSubstitutor>(){

            @Nullable
            protected PsiSubstitutor create(MethodCandidateInfo key2) {
                return key2.getSubstitutor(false);
            }
        };
        this.checkSameSignatures(conflicts, map);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkParametersNumber(conflicts, this.getActualParametersLength(), false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkStaticMethodsOfInterfaces(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (atLeastOneMatch) {
            JavaMethodsConflictResolver.checkPotentiallyCompatibleMethods(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
        }
        int applicabilityLevel = this.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel, map, this.myLanguageLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.getActualParametersLength());
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet uniques = new THashSet(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    private static void checkPotentiallyCompatibleMethods(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkPotentiallyCompatibleMethods"));
        }
        ArrayList<CandidateInfo> partiallyApplicable = new ArrayList<CandidateInfo>();
        Iterator<CandidateInfo> iterator = conflicts.iterator();
        while (iterator.hasNext()) {
            CandidateInfo conflict = iterator.next();
            if (!(conflict instanceof MethodCandidateInfo)) continue;
            ThreeState compatible = ((MethodCandidateInfo)conflict).isPotentiallyCompatible();
            if (compatible == ThreeState.NO) {
                iterator.remove();
                continue;
            }
            if (compatible != ThreeState.UNSURE) continue;
            partiallyApplicable.add(conflict);
        }
        if (conflicts.size() > partiallyApplicable.size()) {
            conflicts.removeAll(partiallyApplicable);
        }
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        this.checkSpecifics(conflicts, applicabilityLevel, null, languageLevel);
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
            for (int i2 = 1; i2 < conflictsCount; ++i2) {
                CandidateInfo method2 = newConflictsArray[i2];
                block5: for (int j = 0; j < i2; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.nonComparable(method2, conflict, applicabilityLevel == 3)) continue;
                    switch (this.isMoreSpecific((MethodCandidateInfo)method2, (MethodCandidateInfo)conflict, applicabilityLevel, map, languageLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method2);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean nonComparable(@NotNull CandidateInfo method2, @NotNull CandidateInfo conflict, boolean fixedArity) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "nonComparable"));
        }
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "nonComparable"));
        }
        assert (method2 != conflict);
        return false;
    }

    protected static void checkAccessStaticLevels(@NotNull List<CandidateInfo> conflicts, boolean checkAccessible) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkAccessStaticLevels"));
        }
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method2 = (MethodCandidateInfo)conflict;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method2) : JavaMethodsConflictResolver.getCheckStaticLevel(method2);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i2 = conflictsCount - 1; i2 >= 0; --i2) {
            if (checkLevels[i2] >= maxCheckLevel) continue;
            conflicts.remove(i2);
        }
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSameSignatures"));
        }
        this.checkSameSignatures(conflicts, null);
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map) {
        PsiMethod method2;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSameSignatures"));
        }
        THashMap signatures = new THashMap(conflicts.size());
        HashSet superMethods = new HashSet();
        for (CandidateInfo conflict : conflicts) {
            method2 = ((MethodCandidateInfo)conflict).getElement();
            PsiClass containingClass = method2.getContainingClass();
            boolean isInterface = containingClass != null && containingClass.isInterface();
            for (HierarchicalMethodSignature methodSignature : method2.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                if (!isInterface) {
                    superMethods.add(superMethod);
                    continue;
                }
                PsiClass aClass = superMethod.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        block2: for (int i2 = 0; i2 < conflicts.size(); ++i2) {
            PsiReferenceExpression expression;
            PsiExpression qualifierExpression;
            PsiClass currentClass;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i2);
            method2 = (PsiMethod)info.getElement();
            if (!method2.hasModifierProperty("static") && superMethods.contains(method2)) {
                conflicts.remove(i2);
                --i2;
                continue;
            }
            PsiClass class1 = method2.getContainingClass();
            PsiSubstitutor infoSubstitutor = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)info, map);
            MethodSignature signature = method2.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1 != null && existingClass != null) {
                if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                    signatures.put(signature, info);
                    continue;
                }
                if (existingClass.isInterface() && "java.lang.Object".equals(class1.getQualifiedName())) {
                    conflicts.remove(info);
                    --i2;
                    continue;
                }
            }
            if (method2 == existingMethod) {
                PsiElement scope1 = info.getCurrentFileResolveScope();
                PsiElement scope2 = existing.getCurrentFileResolveScope();
                if (scope1 instanceof PsiClass && scope2 instanceof PsiClass && PsiTreeUtil.isAncestor((PsiElement)scope1, (PsiElement)scope2, (boolean)true) && !existing.isAccessible()) {
                    signatures.put(signature, info);
                    continue;
                }
            }
            boolean existingTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(existing);
            boolean infoTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(info);
            if (existingTypeParamAgree && !infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(method2, existingMethod)) {
                conflicts.remove(i2);
                --i2;
                continue;
            }
            if (!existingTypeParamAgree && infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method2)) {
                signatures.put(signature, info);
                int index = conflicts.indexOf(existing);
                conflicts.remove(index);
                --i2;
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)existingClass, (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)existingClass, (PsiClass)class1, (boolean)true)) {
                PsiParameter[] parameters = method2.getParameterList().getParameters();
                PsiParameter[] existingParameters = existingMethod.getParameterList().getParameters();
                int parametersLength = parameters.length;
                for (int i1 = 0; i1 < parametersLength; ++i1) {
                    if (!(parameters[i1].getType() instanceof PsiArrayType) || existingParameters[i1].getType() instanceof PsiArrayType) continue;
                    signatures.put(signature, info);
                    continue block2;
                }
                PsiType returnType1 = method2.getReturnType();
                PsiType returnType2 = existingMethod.getReturnType();
                if (returnType1 != null && returnType2 != null && !(returnType1 = infoSubstitutor.substitute(returnType1)).equals(returnType2 = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)existing, map).substitute(returnType2)) && returnType1.isAssignableFrom(returnType2)) {
                    conflicts.remove(i2);
                    --i2;
                    continue;
                }
                signatures.put(signature, info);
                continue;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myArgumentsList, PsiMethodCallExpression.class);
            if (methodCallExpression == null || (currentClass = (qualifierExpression = (expression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null ? PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression.getType()) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null || existingClass == null || class1 == null) continue;
            PsiSubstitutor eSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)existingClass, (PsiClass)currentClass, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
            PsiSubstitutor cSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)class1, (PsiClass)currentClass, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
            if (eSubstitutor == null || cSubstitutor == null || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)existingMethod.getSignature(eSubstitutor), (MethodSignature)method2.getSignature(cSubstitutor))) continue;
            PsiType returnType = eSubstitutor.substitute(existingMethod.getReturnType());
            PsiType returnType1 = cSubstitutor.substitute(method2.getReturnType());
            if (returnType == null || returnType1 == null || returnType1.equals(returnType)) continue;
            if (TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)returnType1, (boolean)false)) {
                if (class1.isInterface() && !existingClass.isInterface()) continue;
                conflicts.remove(existing);
            } else {
                if (!TypeConversionUtil.isAssignable((PsiType)returnType1, (PsiType)returnType, (boolean)false)) continue;
                conflicts.remove(i2);
            }
            --i2;
            break;
        }
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(MethodCandidateInfo existing, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map) {
        PsiSubstitutor psiSubstitutor = map != null ? (PsiSubstitutor)map.get((Object)existing) : existing.getSubstitutor(false);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    private static boolean areTypeParametersAgree(@NotNull CandidateInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "areTypeParametersAgree"));
        }
        return ((MethodCandidateInfo)info).getPertinentApplicabilityLevel() != 1;
    }

    private void checkStaticMethodsOfInterfaces(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkStaticMethodsOfInterfaces"));
        }
        if (!(this.myArgumentsList instanceof PsiExpressionList)) {
            return;
        }
        PsiClass qualifierClass = null;
        Iterator<CandidateInfo> iterator = conflicts.iterator();
        while (iterator.hasNext()) {
            PsiClass containingClass;
            PsiMethod method2;
            CandidateInfo conflict = iterator.next();
            if (!(conflict instanceof MethodCandidateInfo) || !(method2 = ((MethodCandidateInfo)conflict).getElement()).hasModifierProperty("static") || conflict.getCurrentFileResolveScope() instanceof PsiImportStaticStatement || (containingClass = method2.getContainingClass()) == null || !containingClass.isInterface()) continue;
            if (qualifierClass == null && (qualifierClass = this.getQualifiedClass(method2)) == null) {
                return;
            }
            if (containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)qualifierClass)) continue;
            iterator.remove();
        }
    }

    private PsiClass getQualifiedClass(PsiMethod method2) {
        PsiElement parent = this.myArgumentsList.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiExpression expression = ((PsiMethodCallExpression)parent).getMethodExpression().getQualifierExpression();
            if (expression instanceof PsiReferenceExpression) {
                PsiElement resolve = ((PsiReferenceExpression)expression).resolve();
                if (resolve instanceof PsiClass) {
                    return (PsiClass)resolve;
                }
            } else if (expression == null && !ImportsUtil.hasStaticImportOn((PsiElement)parent, (PsiMember)method2, (boolean)true)) {
                return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
            }
            if (expression != null) {
                return PsiUtil.resolveClassInType((PsiType)expression.getType());
            }
        }
        return null;
    }

    public boolean checkParametersNumber(@NotNull List<CandidateInfo> conflicts, int argumentsCount, boolean ignoreIfStaticsProblem) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkParametersNumber"));
        }
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i2 = 0; i2 < conflicts.size(); ++i2) {
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i2);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method2 = ((MethodCandidateInfo)info).getElement();
            int parametersCount = method2.getParameterList().getParametersCount();
            if ((this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? ((MethodCandidateInfo)info).isVarargs() : method2.isVarArgs()) && parametersCount - 1 <= argumentsCount || parametersCount == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        int index = unmatchedIndices.get(u);
                        conflicts.remove(index);
                        --i2;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i2);
                --i2;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i2);
            }
            unmatchedIndices.add(i2);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts) {
        int level;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkApplicability"));
        }
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator.next();
                level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)info);
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getPertinentApplicabilityLevel"));
        }
        return conflict.getPertinentApplicabilityLevel();
    }

    private static int getCheckAccessLevel(@NotNull MethodCandidateInfo method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getCheckAccessLevel"));
        }
        boolean visible = method2.isAccessible();
        return visible ? 1 : 0;
    }

    private static int getCheckStaticLevel(@NotNull MethodCandidateInfo method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getCheckStaticLevel"));
        }
        boolean available = method2.isStaticsScopeCorrect();
        return (available ? 1 : 0) << 1 | (method2.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private int getActualParametersLength() {
        if (this.myActualParameterTypes == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, (Object)this.myArgumentsList);
            return ((PsiExpressionList)this.myArgumentsList).getExpressions().length;
        }
        return this.myActualParameterTypes.length;
    }

    private Specifics isMoreSpecific(@NotNull MethodCandidateInfo info1, @NotNull MethodCandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map, @NotNull LanguageLevel languageLevel) {
        boolean varargs2;
        boolean varargs1;
        if (info1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        if (info2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        PsiMethod method1 = info1.getElement();
        PsiMethod method2 = info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = JavaMethodsConflictResolver.getSubstitutor(info1, map);
        PsiSubstitutor classSubstitutor2 = JavaMethodsConflictResolver.getSubstitutor(info2, map);
        int argsLength = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method1.isVarArgs() || method2.isVarArgs()) ? this.getActualParametersLength() : 0;
        int max = Math.max(Math.max(params1.length, params2.length), argsLength);
        PsiType[] types1 = PsiType.createArray((int)max);
        PsiType[] types2 = PsiType.createArray((int)max);
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i2 = 0; i2 < max; ++i2) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i2, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i2, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && class1 != null && (!JavaVersionService.getInstance().isAtLeast((PsiElement)class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                }
            }
            types1[i2] = type1;
            types2[i2] = type2;
        }
        boolean sameBoxing = true;
        boolean[] boxingHappened = new boolean[2];
        PsiExpression[] args = this.myArgumentsList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentsList).getExpressions() : null;
        for (int i3 = 0; i3 < types1.length; ++i3) {
            PsiType argType;
            ProgressManager.checkCanceled();
            PsiExpression arg = args != null && i3 < args.length ? args[i3] : null;
            PsiType psiType = argType = this.myActualParameterTypes != null && i3 < this.getActualParametersLength() ? this.myActualParameterTypes[i3] : null;
            if (arg == null && argType == null) continue;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor1.substitute(types1[i3]), argType, arg)) {
                boxingHappened[0] = boxingHappened[0] | true;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor2.substitute(types2[i3]), argType, arg)) {
                boxingHappened[1] = boxingHappened[1] | true;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (!boxingHappened[0] && boxingHappened[1]) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] && !boxingHappened[1]) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor1 = info1.getSiteSubstitutor();
            PsiSubstitutor siteSubstitutor2 = info2.getSiteSubstitutor();
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor2);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor1);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, languageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, languageLevel, varargsPosition, methodSubstitutor1, method2, siteSubstitutor2);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, languageLevel);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, languageLevel, varargsPosition, methodSubstitutor2, method1, siteSubstitutor1);
            if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                boolean typeArgsApplicable12 = GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])typeParameters1, (PsiSubstitutor)methodSubstitutor1, (PsiElement)this.myArgumentsList, (!applicable21 ? 1 : 0) != 0);
                boolean typeArgsApplicable21 = GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])typeParameters2, (PsiSubstitutor)methodSubstitutor2, (PsiElement)this.myArgumentsList, (!applicable12 ? 1 : 0) != 0);
                if (!typeArgsApplicable12) {
                    applicable12 = false;
                }
                if (!typeArgsApplicable21) {
                    applicable21 = false;
                }
            }
            if (applicable12 || applicable21) {
                boolean abstract2;
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (applicable21 && !applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract") || method1.hasModifierProperty("default");
                boolean bl = abstract2 = method2.hasModifierProperty("abstract") || method2.hasModifierProperty("default");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
                if (abstract1 && abstract2 && MethodSignatureUtil.areOverrideEquivalent((PsiMethod)method1, (PsiMethod)method2)) {
                    PsiType returnType1 = method1.getReturnType();
                    PsiType returnType2 = method2.getReturnType();
                    if (returnType1 != null && returnType2 != null && returnType1.isAssignableFrom(returnType2)) {
                        return Specifics.SECOND;
                    }
                    return Specifics.FIRST;
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable((PsiType)lastParamType2, (PsiType)lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable((PsiType)lastParamType1, (PsiType)lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2) {
            if (class2.isInheritor(class1, true) || class1.isInterface() && !class2.isInterface()) {
                if (JavaMethodsConflictResolver.isSubSignature(method1, method2, classSubstitutor1, classSubstitutor2, boxingHappened)) {
                    return Specifics.SECOND;
                }
            } else if ((class1.isInheritor(class2, true) || class2.isInterface()) && JavaMethodsConflictResolver.isSubSignature(method2, method1, classSubstitutor2, classSubstitutor1, boxingHappened)) {
                return Specifics.FIRST;
            }
        }
        if ((varargs1 = info1.isVarargs()) ^ (varargs2 = info2.isVarargs())) {
            return varargs1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private static boolean isBoxingUsed(PsiType parameterType, @Nullable PsiType argType, PsiExpression arg) {
        ProgressManager.checkCanceled();
        boolean isExpressionTypePrimitive = argType != null ? argType instanceof PsiPrimitiveType : PsiPolyExpressionUtil.isExpressionOfPrimitiveType((PsiExpression)arg);
        return parameterType instanceof PsiPrimitiveType ^ isExpressionTypePrimitive;
    }

    private static boolean isSubSignature(PsiMethod method1, PsiMethod method2, PsiSubstitutor classSubstitutor1, PsiSubstitutor classSubstitutor2, boolean[] boxingHappened) {
        return MethodSignatureUtil.areErasedParametersEqual((MethodSignature)method1.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)method2.getSignature(PsiSubstitutor.EMPTY)) && MethodSignatureUtil.isSubsignature((MethodSignature)method1.getSignature(classSubstitutor1), (MethodSignature)method2.getSignature(classSubstitutor2)) || method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && !boxingHappened[0];
    }

    private boolean isApplicableTo(@NotNull PsiType[] types2AtSite, @NotNull PsiMethod method1, final @NotNull LanguageLevel languageLevel, boolean varargsPosition, @NotNull PsiSubstitutor methodSubstitutor1, @NotNull PsiMethod method2, final PsiSubstitutor siteSubstitutor1) {
        PsiElement parent;
        if (types2AtSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types2AtSite", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (methodSubstitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSubstitutor1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && method1.getTypeParameters().length > 0 && this.myArgumentsList instanceof PsiExpressionList && (parent = this.myArgumentsList.getParent()) instanceof PsiCallExpression) {
            return InferenceSession.isMoreSpecific(method2, method1, siteSubstitutor1, ((PsiExpressionList)this.myArgumentsList).getExpressions(), this.myArgumentsList, varargsPosition);
        }
        PsiUtil.ApplicabilityChecker applicabilityChecker = new PsiUtil.ApplicabilityChecker(){

            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                PsiClass rightClass;
                if (right instanceof PsiClassType && (rightClass = ((PsiClassType)right).resolve()) instanceof PsiTypeParameter) {
                    right = new PsiImmediateClassType(rightClass, siteSubstitutor1);
                }
                return languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? JavaMethodsConflictResolver.this.isTypeMoreSpecific(left, right, argId) : TypeConversionUtil.isAssignable((PsiType)left, (PsiType)right, (boolean)allowUncheckedConversion);
            }
        };
        int applicabilityLevel = PsiUtil.getApplicabilityLevel((PsiMethod)method1, (PsiSubstitutor)methodSubstitutor1, (PsiType[])types2AtSite, (LanguageLevel)languageLevel, (boolean)false, (boolean)varargsPosition, (PsiUtil.ApplicabilityChecker)applicabilityChecker);
        return applicabilityLevel > 1;
    }

    private boolean isTypeMoreSpecific(PsiType left, PsiType right, int argId) {
        PsiExpression[] expressions;
        if (TypeConversionUtil.isAssignable((PsiType)left, (PsiType)right, (boolean)false)) {
            return true;
        }
        if (this.myArgumentsList instanceof PsiExpressionList && argId < (expressions = ((PsiExpressionList)this.myArgumentsList).getExpressions()).length) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(expressions[argId], right, left);
        }
        return false;
    }

    @NotNull
    private static PsiType[] typesAtSite(@NotNull PsiType[] types1, @NotNull PsiSubstitutor siteSubstitutor1) {
        if (types1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        if (siteSubstitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siteSubstitutor1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        PsiType[] types = PsiType.createArray((int)types1.length);
        for (int i2 = 0; i2 < types1.length; ++i2) {
            types[i2] = siteSubstitutor1.substitute(types1[i2]);
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        return types;
    }

    @NotNull
    private static PsiSubstitutor calculateMethodSubstitutor(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiMethod method2, @NotNull PsiSubstitutor siteSubstitutor, @NotNull PsiType[] types1, @NotNull PsiType[] types2, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (siteSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siteSubstitutor", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (types1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)method2.getProject()).inferTypeArguments(typeParameters, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method2)) {
            PsiClass aClass;
            PsiType type;
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (!substitutor.getSubstitutionMap().containsKey(typeParameter)) {
                type = siteSubstitutor.substitute(typeParameter);
                if (type instanceof PsiClassType && typeParameter.getOwner() == method2 && (aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method2) {
                    type = TypeConversionUtil.erasure((PsiType)type, (PsiSubstitutor)siteSubstitutor);
                }
                substitutor = substitutor.put(typeParameter, type);
                continue;
            }
            type = substitutor.substitute(typeParameter);
            if (!(type instanceof PsiClassType) || !((aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter)) continue;
            substitutor = substitutor.put(typeParameter, (PsiType)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, siteSubstitutor));
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        return psiSubstitutor;
    }

    public void checkPrimitiveVarargs(@NotNull List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type;
        PsiType componentType;
        PsiMethod method2;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkPrimitiveVarargs"));
        }
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            ProgressManager.checkCanceled();
            method2 = (PsiMethod)conflict.getElement();
            int parametersCount = method2.getParameterList().getParametersCount();
            if (!method2.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal((Object)(componentType = ((PsiArrayType)(type = method2.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType()), (Object)(classType = PsiType.getJavaLangObject((PsiManager)method2.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)method2.getProject()))))) continue;
            objectVararg = conflict;
        }
        if (objectVararg != null) {
            for (CandidateInfo conflict : conflicts) {
                ProgressManager.checkCanceled();
                method2 = (PsiMethod)conflict.getElement();
                if (method2 == objectVararg || !method2.isVarArgs()) continue;
                int paramsCount = method2.getParameterList().getParametersCount();
                type = method2.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiExpression expr, PsiType sType, PsiType tType) {
        if (expr instanceof PsiParenthesizedExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiParenthesizedExpression)expr).getExpression(), sType, tType);
        }
        if (expr instanceof PsiConditionalExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getThenExpression(), sType, tType) && JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getElseExpression(), sType, tType);
        }
        if (expr instanceof PsiFunctionalExpression) {
            if (expr instanceof PsiLambdaExpression && !((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            if (expr instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)expr).isExact()) {
                return false;
            }
            if (LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType) && !TypeConversionUtil.erasure((PsiType)tType).isAssignableFrom(sType) && !TypeConversionUtil.erasure((PsiType)sType).isAssignableFrom(tType)) {
                return InferenceSession.isFunctionalTypeMoreSpecificOnExpression(sType, tType, expr);
            }
        }
        return false;
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

