/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.search.MethodDeepestSuperSearcher;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleManagerImpl
extends JavaCodeStyleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl");
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String FIND_PREFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    @NonNls
    private static final String SET_PREFIX = "set";
    private final Project myProject;

    public JavaCodeStyleManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        PsiElement psiElement = this.shortenClassReferences(element, 0);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
            }
            return psiElement;
        }
        boolean addImports = !BitUtil.isSet((int)flags, (int)4096);
        boolean incompleteCode = BitUtil.isSet((int)flags, (int)8192);
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), addImports, incompleteCode, this.myProject);
            Object t = SourceTreeToPsiMap.treeToPsiNotNull(reference);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
            }
            return t;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        return psiElement;
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        ReferenceAdjuster adjuster;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        CheckUtil.checkWritable(element);
        if (SourceTreeToPsiMap.hasTreeElement(element) && (adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            adjuster.processRange(element.getNode(), startOffset, endOffset, this.myProject);
        }
    }

    @NotNull
    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "qualifyClassReferences"));
        }
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), false, false, true, true);
            Object t = SourceTreeToPsiMap.treeToPsiNotNull(reference);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "qualifyClassReferences"));
            }
            return t;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "qualifyClassReferences"));
        }
        return psiElement;
    }

    public void optimizeImports(@NotNull PsiFile file2) throws IncorrectOperationException {
        PsiImportList importList;
        PsiImportList newList;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "optimizeImports"));
        }
        CheckUtil.checkWritable((PsiElement)file2);
        if (file2 instanceof PsiJavaFile && (newList = this.prepareOptimizeImportsResult((PsiJavaFile)file2)) != null && (importList = ((PsiJavaFile)file2).getImportList()) != null) {
            importList.replace((PsiElement)newList);
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "prepareOptimizeImportsResult"));
        }
        return new ImportHelper(this.getSettings()).prepareOptimizeImportsResult(file2);
    }

    public boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "addImport"));
        }
        return new ImportHelper(this.getSettings()).addImport(file2, refClass);
    }

    public void removeRedundantImports(@NotNull PsiJavaFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "removeRedundantImports"));
        }
        Collection<PsiImportStatementBase> redundant = this.findRedundantImports(file2);
        if (redundant == null) {
            return;
        }
        for (PsiImportStatementBase importStatement : redundant) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || ref.resolve() == null) continue;
            importStatement.delete();
        }
    }

    @Nullable
    public Collection<PsiImportStatementBase> findRedundantImports(final @NotNull PsiJavaFile file2) {
        THashSet redundant;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "findRedundantImports"));
        }
        PsiImportList importList = file2.getImportList();
        if (importList == null) {
            return null;
        }
        Object[] imports = importList.getAllImportStatements();
        if (imports.length == 0) {
            return null;
        }
        THashSet allImports = new THashSet(Arrays.asList(imports));
        if (FileTypeUtils.isInServerPageFile((PsiElement)file2)) {
            redundant = ContainerUtil.newIdentityTroveSet();
            ContainerUtil.addAll((Collection)redundant, (Object[])imports);
            redundant.removeAll((Collection<?>)allImports);
            for (Object importStatement : imports) {
                if (!(importStatement instanceof JspxImportStatement) || !importStatement.isForeignFileImport()) continue;
                redundant.remove(importStatement);
            }
        } else {
            redundant = allImports;
            List roots = file2.getViewProvider().getAllFiles();
            for (PsiElement root : roots) {
                root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Collection)redundant){
                    final /* synthetic */ Collection val$redundant;
                    {
                        this.val$redundant = collection;
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        PsiElement resolveScope;
                        JavaResolveResult resolveResult;
                        if (!reference.isQualified() && !this.inTheSamePackage(file2, (resolveResult = reference.advancedResolve(false)).getElement()) && (resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
                            PsiImportStatementBase importStatementBase = (PsiImportStatementBase)resolveScope;
                            this.val$redundant.remove(importStatementBase);
                        }
                        super.visitReferenceElement(reference);
                    }

                    private boolean inTheSamePackage(PsiJavaFile file22, PsiElement element) {
                        PsiFile containingFile;
                        if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                            return Comparing.strEqual((String)file22.getPackageName(), (String)((PsiJavaFile)containingFile).getPackageName());
                        }
                        return false;
                    }
                });
            }
        }
        return redundant;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "findEntryIndex"));
        }
        return new ImportHelper(this.getSettings()).findEntryIndex(statement2);
    }

    @NotNull
    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestCompiledParameterName"));
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(this.suggestVariableNameByType(type, VariableKind.PARAMETER, true, true)){};
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestCompiledParameterName"));
        }
        return suggestedNameInfo;
    }

    @NotNull
    public SuggestedNameInfo suggestVariableName(final @NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type, boolean correctKeywords) {
        NamesByExprInfo namesByExpr;
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableName"));
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (expr != null && type == null) {
            type = expr.getType();
        }
        if (propertyName != null) {
            Object[] namesByName = this.getSuggestionsByName(propertyName, kind, false, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByName, kind, propertyName, null);
            ContainerUtil.addAll(names, (Object[])namesByName);
        }
        if (expr != null) {
            namesByExpr = this.suggestVariableNameByExpression(expr, kind, correctKeywords);
            if (namesByExpr.propertyName != null) {
                JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesByExpr.names, kind, namesByExpr.propertyName, null);
            }
            ContainerUtil.addAll(names, (Object[])namesByExpr.names);
        } else {
            namesByExpr = null;
        }
        if (type != null) {
            Object[] namesByType = this.suggestVariableNameByType(type, kind, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByType, kind, null, type);
            ContainerUtil.addAll(names, (Object[])namesByType);
        }
        final String _propertyName = propertyName != null ? propertyName : (namesByExpr != null ? namesByExpr.propertyName : null);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(names, kind, _propertyName, type);
        String[] namesArray = ArrayUtil.toStringArray(names);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind, _propertyName, type);
        final PsiType _type = type;
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(namesArray){

            public void nameChosen(String name) {
                if (_propertyName != null || _type != null && _type.isValid()) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name, (VariableKind)kind, (String)_propertyName, (PsiType)_type);
                }
            }
        };
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableName"));
        }
        return suggestedNameInfo;
    }

    private static void addNamesFromStatistics(@NotNull Set<String> names, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "addNamesFromStatistics"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "addNamesFromStatistics"));
        }
        String[] allNames = JavaStatisticsManager.getAllVariableNamesUsed((VariableKind)variableKind, (String)propertyName, (PsiType)type);
        int maxFrequency = 0;
        for (String name : allNames) {
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            maxFrequency = Math.max(maxFrequency, count);
        }
        int frequencyLimit = Math.max(5, maxFrequency / 2);
        for (String name : allNames) {
            if (names.contains(name)) continue;
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            if (LOG.isDebugEnabled()) {
                LOG.debug("new name:" + name + " count:" + count);
                LOG.debug("frequencyLimit:" + frequencyLimit);
            }
            if (count < frequencyLimit) continue;
            names.add(name);
        }
        if (propertyName != null && type != null) {
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, propertyName, null);
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, null, type);
        }
    }

    @NotNull
    private String[] suggestVariableNameByType(@NotNull PsiType type, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
        }
        String[] stringArray = this.suggestVariableNameByType(type, variableKind, correctKeywords, false);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
        }
        return stringArray;
    }

    @NotNull
    private String[] suggestVariableNameByType(@NotNull PsiType type, @NotNull VariableKind variableKind, boolean correctKeywords, boolean skipIndices) {
        String typeName;
        PsiClass psiClass;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
        }
        String longTypeName = skipIndices ? type.getCanonicalText() : JavaCodeStyleManagerImpl.getLongTypeName(type);
        CodeStyleSettings.TypeToNameMap map = this.getMapByVariableKind(variableKind);
        if (map != null && longTypeName != null) {
            String name;
            if (type.equals(PsiType.NULL)) {
                longTypeName = "java.lang.Object";
            }
            if ((name = map.nameByType(longTypeName)) != null && this.isIdentifier(name)) {
                String[] stringArray = this.getSuggestionsByName(name, variableKind, type instanceof PsiArrayType, correctKeywords);
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
                }
                return stringArray;
            }
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        PsiClass psiClass2 = psiClass = !skipIndices && type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
        if (!skipIndices) {
            this.suggestNamesForCollectionInheritors(type, variableKind, suggestions, correctKeywords);
            if (psiClass != null && "java.util.Optional".equals(psiClass.getQualifiedName()) && ((PsiClassType)type).getParameterCount() == 1) {
                PsiType optionalContent = ((PsiClassType)type).getParameters()[0];
                Collections.addAll(suggestions, this.suggestVariableNameByType(optionalContent, variableKind, correctKeywords, false));
            }
            this.suggestNamesFromGenericParameters(type, variableKind, suggestions, correctKeywords);
        }
        if ((typeName = JavaCodeStyleManagerImpl.getTypeName(type, !skipIndices)) != null) {
            typeName = JavaCodeStyleManagerImpl.normalizeTypeName(typeName);
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(typeName, variableKind, type instanceof PsiArrayType, correctKeywords));
        }
        if (psiClass != null && psiClass.getContainingClass() != null) {
            InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> {
                if (variableKind == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "lambda$suggestVariableNameByType$0"));
                }
                if (PsiTreeUtil.isAncestor((PsiElement)superClass, (PsiElement)psiClass, (boolean)true)) {
                    ContainerUtil.addAll((Collection)suggestions, (Object[])this.getSuggestionsByName(superClass.getName(), variableKind, false, correctKeywords));
                }
                return false;
            });
        }
        String[] stringArray = ArrayUtil.toStringArray(suggestions);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByType"));
        }
        return stringArray;
    }

    private void suggestNamesFromGenericParameters(@NotNull PsiType type, @NotNull VariableKind variableKind, @NotNull Collection<String> suggestions, boolean correctKeywords) {
        PsiType[] parameters;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestNamesFromGenericParameters"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestNamesFromGenericParameters"));
        }
        if (suggestions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestions", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestNamesFromGenericParameters"));
        }
        if (!(type instanceof PsiClassType)) {
            return;
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        for (PsiType parameter : parameters = ((PsiClassType)type).getParameters()) {
            String typeName;
            if (!(parameter instanceof PsiClassType) || (typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(parameter))) == null) continue;
            fullNameBuilder.append(typeName);
        }
        String baseName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(type));
        if (baseName != null) {
            fullNameBuilder.append(baseName);
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(fullNameBuilder.toString(), variableKind, false, correctKeywords));
        }
    }

    private void suggestNamesForCollectionInheritors(@NotNull PsiType type, @NotNull VariableKind variableKind, @NotNull Collection<String> suggestions, boolean correctKeywords) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestNamesForCollectionInheritors"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestNamesForCollectionInheritors"));
        }
        if (suggestions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestions", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestNamesForCollectionInheritors"));
        }
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
        if (componentType == null || componentType.equals(type)) {
            return;
        }
        String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(componentType));
        if (typeName != null) {
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(typeName, variableKind, true, correctKeywords));
        }
    }

    private static String normalizeTypeName(@Nullable String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @Nullable
    public static String getTypeName(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getTypeName"));
        }
        return JavaCodeStyleManagerImpl.getTypeName(type, true);
    }

    @Nullable
    private static String getTypeName(@NotNull PsiType type, boolean withIndices) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getTypeName"));
        }
        if ((type = type.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            String className = classType.getClassName();
            if (className != null || !withIndices) {
                return className;
            }
            PsiClass aClass = classType.resolve();
            return aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getClassName() : null;
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getPresentableText();
        }
        if (type instanceof PsiWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiWildcardType)type).getExtendsBound(), withIndices);
        }
        if (type instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiIntersectionType)type).getRepresentative(), withIndices);
        }
        if (type instanceof PsiCapturedWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName((PsiType)((PsiCapturedWildcardType)type).getWildcard(), withIndices);
        }
        if (type instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiDisjunctionType)type).getLeastUpperBound(), withIndices);
        }
        return null;
    }

    @Nullable
    private static String getLongTypeName(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getLongTypeName"));
        }
        if (type instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type).resolve();
            if (aClass == null) {
                return null;
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                return baseClass != null ? baseClass.getQualifiedName() : null;
            }
            return aClass.getQualifiedName();
        }
        if (type instanceof PsiArrayType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiArrayType)type).getComponentType()) + "[]";
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getPresentableText();
        }
        if (type instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type).getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type).getWildcard().getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiIntersectionType)type).getRepresentative());
        }
        if (type instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiDisjunctionType)type).getLeastUpperBound());
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpression(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpression"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpression"));
        }
        LinkedHashSet names = new LinkedHashSet();
        Object[] fromLiterals = this.suggestVariableNameFromLiterals(expr, variableKind, correctKeywords);
        if (fromLiterals != null) {
            ContainerUtil.addAll(names, (Object[])fromLiterals);
        }
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, false).names);
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionPlace(expr, variableKind, correctKeywords).names);
        PsiType type = expr.getType();
        if (type != null) {
            ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByType(type, variableKind, correctKeywords));
        }
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, true).names);
        String[] namesArray = ArrayUtil.toStringArray(names);
        String propertyName = this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, false).propertyName != null ? this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, false).propertyName : this.suggestVariableNameByExpressionPlace(expr, variableKind, correctKeywords).propertyName;
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, namesArray);
        if (namesByExprInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpression"));
        }
        return namesByExprInfo;
    }

    @Nullable
    private String[] suggestVariableNameFromLiterals(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameFromLiterals"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameFromLiterals"));
        }
        PsiElement[] literals = PsiTreeUtil.collectElements((PsiElement)expr, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiElement exprList;
                if (JavaCodeStyleManagerImpl.isStringPsiLiteral(element) && StringUtil.isJavaIdentifier((String)StringUtil.unquoteString((String)element.getText())) && (exprList = element.getParent()) instanceof PsiExpressionList) {
                    PsiElement call = exprList.getParent();
                    if (call instanceof PsiNewExpression) {
                        return true;
                    }
                    if (call instanceof PsiMethodCallExpression) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (literals.length == 1) {
            String text = StringUtil.unquoteString((String)literals[0].getText());
            return this.getSuggestionsByName(text, variableKind, expr.getType() instanceof PsiArrayType, correctKeywords);
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionOnly(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords, boolean useAllMethodNames) {
        PsiType functionalInterfaceType;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
        }
        if (expr instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)expr).getMethodExpression();
            String methodName = methodExpr.getReferenceName();
            if (methodName != null) {
                PsiExpression[] expressions;
                if (("of".equals(methodName) || "ofNullable".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr) && (expressions = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length > 0) {
                    NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(expressions[0], variableKind, correctKeywords, useAllMethodNames);
                    if (namesByExprInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                    }
                    return namesByExprInfo;
                }
                if (("map".equals(methodName) || "flatMap".equals(methodName) || "filter".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr)) {
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, new String[0]);
                    if (namesByExprInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                    }
                    return namesByExprInfo;
                }
                String[] words = NameUtil.nameToWords((String)methodName);
                if (words.length > 0) {
                    String firstWord = words[0];
                    if (GET_PREFIX.equals(firstWord) || IS_PREFIX.equals(firstWord) || FIND_PREFIX.equals(firstWord) || CREATE_PREFIX.equals(firstWord)) {
                        if (words.length > 1) {
                            String propertyName = methodName.substring(firstWord.length());
                            Object[] names = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                            PsiExpression qualifierExpression = methodExpr.getQualifierExpression();
                            if (qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiVariable) {
                                names = (String[])ArrayUtil.append((Object[])names, (Object)StringUtil.sanitizeJavaIdentifier((String)this.changeIfNotIdentifier(qualifierExpression.getText() + StringUtil.capitalize((String)propertyName))));
                            }
                            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, (String[])names);
                            if (namesByExprInfo == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                            }
                            return namesByExprInfo;
                        }
                    } else if (words.length == 1 || useAllMethodNames) {
                        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(methodName, this.getSuggestionsByName(methodName, variableKind, false, correctKeywords));
                        if (namesByExprInfo == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                        }
                        return namesByExprInfo;
                    }
                }
            }
        } else if (expr instanceof PsiReferenceExpression) {
            String propertyName = ((PsiReferenceExpression)expr).getReferenceName();
            PsiElement refElement = ((PsiReferenceExpression)expr).resolve();
            if (refElement instanceof PsiVariable) {
                VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                propertyName = this.variableNameToPropertyName(propertyName, refVariableKind);
            }
            if (refElement != null && propertyName != null) {
                String[] names = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, names);
                if (namesByExprInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiArrayAccessExpression) {
            PsiExpression arrayExpr = ((PsiArrayAccessExpression)expr).getArrayExpression();
            if (arrayExpr instanceof PsiReferenceExpression) {
                String name;
                String arrayName = ((PsiReferenceExpression)arrayExpr).getReferenceName();
                PsiElement refElement = ((PsiReferenceExpression)arrayExpr).resolve();
                if (refElement instanceof PsiVariable) {
                    VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                    arrayName = this.variableNameToPropertyName(arrayName, refVariableKind);
                }
                if (arrayName != null && (name = StringUtil.unpluralize((String)arrayName)) != null) {
                    String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name, names);
                    if (namesByExprInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                    }
                    return namesByExprInfo;
                }
            }
        } else if (expr instanceof PsiLiteralExpression && variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String stringValue;
            String[] names;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            Object value = literalExpression.getValue();
            if (value instanceof String && (names = JavaCodeStyleManagerImpl.getSuggestionsByValue(stringValue = (String)value)).length > 0) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, new String[]{JavaCodeStyleManagerImpl.constantValueToConstantName(names)});
                if (namesByExprInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiParenthesizedExpression) {
            PsiExpression expression = ((PsiParenthesizedExpression)expr).getExpression();
            if (expression != null) {
                NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(expression, variableKind, correctKeywords, useAllMethodNames);
                if (namesByExprInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiTypeCastExpression) {
            PsiExpression operand = ((PsiTypeCastExpression)expr).getOperand();
            if (operand != null) {
                NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(operand, variableKind, correctKeywords, useAllMethodNames);
                if (namesByExprInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiLiteralExpression) {
            String text = StringUtil.unquoteString((String)expr.getText());
            if (this.isIdentifier(text)) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(text, this.getSuggestionsByName(text, variableKind, false, correctKeywords));
                if (namesByExprInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiFunctionalExpression && (functionalInterfaceType = ((PsiFunctionalExpression)expr).getFunctionalInterfaceType()) != null) {
            String[] namesByType = this.suggestVariableNameByType(functionalInterfaceType, variableKind, correctKeywords);
            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, namesByType);
            if (namesByExprInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
            }
            return namesByExprInfo;
        }
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (namesByExprInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionOnly"));
        }
        return namesByExprInfo;
    }

    private static boolean isJavaUtilMethodCall(@NotNull PsiMethodCallExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "isJavaUtilMethodCall"));
        }
        PsiMethod method2 = expr.resolveMethod();
        if (method2 == null) {
            return false;
        }
        return JavaCodeStyleManagerImpl.isJavaUtilMethod(method2) || !MethodDeepestSuperSearcher.processDeepestSuperMethods(method2, (Processor<PsiMethod>)((Processor)method1 -> !JavaCodeStyleManagerImpl.isJavaUtilMethod(method1)));
    }

    private static boolean isJavaUtilMethod(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "isJavaUtilMethod"));
        }
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method2);
        return name != null && name.startsWith("java.util.");
    }

    @NotNull
    private static String constantValueToConstantName(@NotNull String[] names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "constantValueToConstantName"));
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (i2 > 0) {
                result2.append("_");
            }
            result2.append(names[i2]);
        }
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "constantValueToConstantName"));
        }
        return string;
    }

    @NotNull
    private static String[] getSuggestionsByValue(@NotNull String stringValue) {
        if (stringValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringValue", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuggestionsByValue"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        boolean prevIsUpperCase = false;
        for (int i2 = 0; i2 < stringValue.length(); ++i2) {
            char c = stringValue.charAt(i2);
            if (Character.isUpperCase(c)) {
                if (currentWord.length() > 0 && !prevIsUpperCase) {
                    result2.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                currentWord.append(c);
            } else if (Character.isLowerCase(c)) {
                currentWord.append(Character.toUpperCase(c));
            } else if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isJavaIdentifierStart(c) || currentWord.length() > 0 || !result2.isEmpty()) {
                    currentWord.append(c);
                }
            } else if (currentWord.length() > 0) {
                result2.add(currentWord.toString());
                currentWord = new StringBuffer();
            }
            prevIsUpperCase = Character.isUpperCase(c);
        }
        if (currentWord.length() > 0) {
            result2.add(currentWord.toString());
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuggestionsByValue"));
        }
        return stringArray;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionPlace(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords) {
        String name;
        PsiExpression leftExpression;
        PsiAssignmentExpression assignmentExpression;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionPlace"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionPlace"));
        }
        if (expr.getParent() instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)expr.getParent();
            PsiElement listParent = list.getParent();
            PsiSubstitutor subst = PsiSubstitutor.EMPTY;
            PsiMethod method2 = null;
            if (listParent instanceof PsiMethodCallExpression) {
                JavaResolveResult resolveResult = ((PsiMethodCallExpression)listParent).getMethodExpression().advancedResolve(false);
                method2 = (PsiMethod)resolveResult.getElement();
                subst = resolveResult.getSubstitutor();
            } else {
                if (listParent instanceof PsiAnonymousClass) {
                    listParent = listParent.getParent();
                }
                if (listParent instanceof PsiNewExpression) {
                    method2 = ((PsiNewExpression)listParent).resolveConstructor();
                }
            }
            if (method2 != null) {
                String name2;
                PsiParameter[] parameters;
                PsiElement navElement = method2.getNavigationElement();
                if (navElement instanceof PsiMethod) {
                    method2 = (PsiMethod)navElement;
                }
                PsiExpression[] expressions = list.getExpressions();
                int index = -1;
                for (int i2 = 0; i2 < expressions.length; ++i2) {
                    if (expressions[i2] != expr) continue;
                    index = i2;
                    break;
                }
                if (index < (parameters = method2.getParameterList().getParameters()).length && (name2 = parameters[index].getName()) != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)subst.substitute(parameters[index].getType()), (PsiExpression)expr)) {
                    String firstWord;
                    String methodName;
                    String[] words;
                    name2 = this.variableNameToPropertyName(name2, VariableKind.PARAMETER);
                    String[] names = this.getSuggestionsByName(name2, variableKind, false, correctKeywords);
                    if (expressions.length == 1 && (words = NameUtil.nameToWords((String)(methodName = method2.getName()))).length > 0 && SET_PREFIX.equals(firstWord = words[0])) {
                        String propertyName = methodName.substring(firstWord.length());
                        String[] setterNames = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                        names = ArrayUtil.mergeArrays((String[])names, (String[])setterNames);
                    }
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name2, names);
                    if (namesByExprInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionPlace"));
                    }
                    return namesByExprInfo;
                }
            }
        } else if (expr.getParent() instanceof PsiAssignmentExpression && variableKind == VariableKind.PARAMETER && expr == (assignmentExpression = (PsiAssignmentExpression)expr.getParent()).getRExpression() && (leftExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)leftExpression).getQualifier() == null && (name = leftExpression.getText()) != null) {
            PsiElement resolve = ((PsiReferenceExpression)leftExpression).resolve();
            if (resolve instanceof PsiVariable) {
                name = this.variableNameToPropertyName(name, this.getVariableKind((PsiVariable)resolve));
            }
            String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name, names);
            if (namesByExprInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionPlace"));
            }
            return namesByExprInfo;
        }
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (namesByExprInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableNameByExpressionPlace"));
        }
        return namesByExprInfo;
    }

    @NotNull
    public String variableNameToPropertyName(@NotNull String name, @NotNull VariableKind variableKind) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyName"));
        }
        if (variableKind == VariableKind.STATIC_FINAL_FIELD || variableKind == VariableKind.STATIC_FIELD && name.contains("_")) {
            StringBuilder buffer = new StringBuilder();
            for (int i2 = 0; i2 < name.length(); ++i2) {
                char c = name.charAt(i2);
                if (c != '_') {
                    if (Character.isLowerCase(c)) {
                        String string = this.variableNameToPropertyNameInner(name, variableKind);
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyName"));
                        }
                        return string;
                    }
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (++i2 >= name.length()) continue;
                c = name.charAt(i2);
                buffer.append(c);
            }
            String string = buffer.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyName"));
            }
            return string;
        }
        String string = this.variableNameToPropertyNameInner(name, variableKind);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyName"));
        }
        return string;
    }

    @NotNull
    private String variableNameToPropertyNameInner(@NotNull String name, @NotNull VariableKind variableKind) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyNameInner"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyNameInner"));
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        boolean doDecapitalize = false;
        int pLength = prefix.length();
        if (pLength > 0 && name.startsWith(prefix) && name.length() > pLength && (!Character.isLetter(prefix.charAt(pLength - 1)) || Character.isUpperCase(name.charAt(pLength)))) {
            name = name.substring(pLength);
            doDecapitalize = true;
        }
        if (name.endsWith(suffix) && name.length() > suffix.length()) {
            name = name.substring(0, name.length() - suffix.length());
            doDecapitalize = true;
        }
        if (doDecapitalize) {
            name = Introspector.decapitalize(name);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "variableNameToPropertyNameInner"));
        }
        return string;
    }

    @NotNull
    public String propertyNameToVariableName(@NotNull String propertyName, @NotNull VariableKind variableKind) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "propertyNameToVariableName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "propertyNameToVariableName"));
        }
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String[] words = NameUtil.nameToWords((String)propertyName);
            StringBuilder buffer = new StringBuilder();
            for (int i2 = 0; i2 < words.length; ++i2) {
                String word = words[i2];
                if (i2 > 0) {
                    buffer.append("_");
                }
                buffer.append(StringUtil.toUpperCase((String)word));
            }
            String string = buffer.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "propertyNameToVariableName"));
            }
            return string;
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String name = propertyName;
        if (!(name.isEmpty() || prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_'))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        name = prefix + name + this.getSuffixByVariableKind(variableKind);
        String string = name = this.changeIfNotIdentifier(name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "propertyNameToVariableName"));
        }
        return string;
    }

    @NotNull
    private String[] getSuggestionsByName(@NotNull String name, @NotNull VariableKind variableKind, boolean isArray, boolean correctKeywords) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuggestionsByName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuggestionsByName"));
        }
        boolean upperCaseStyle = variableKind == VariableKind.STATIC_FINAL_FIELD;
        boolean preferLongerNames = this.getSettings().PREFER_LONGER_NAMES;
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : NameUtil.getSuggestionsByName((String)name, (String)prefix, (String)suffix, (boolean)upperCaseStyle, (boolean)preferLongerNames, (boolean)isArray)) {
            answer.add(correctKeywords ? this.changeIfNotIdentifier(suggestion) : suggestion);
        }
        String[] stringArray = ArrayUtil.toStringArray(answer);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuggestionsByName"));
        }
        return stringArray;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        String string = JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, lookForward, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        return string;
    }

    @NotNull
    private static String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward, boolean allowShadowing) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMethod.class});
        int index = 0;
        while (true) {
            String name;
            String string = name = index > 0 ? baseName + index : baseName;
            if (!(JavaCodeStyleManagerImpl.hasConflictingVariable(place, name, allowShadowing) || lookForward && JavaCodeStyleManagerImpl.hasConflictingVariableAfterwards(scope, name))) {
                String string2 = name;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
                }
                return string2;
            }
            ++index;
        }
    }

    private static boolean hasConflictingVariableAfterwards(@Nullable PsiElement scope, final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "hasConflictingVariableAfterwards"));
        }
        for (PsiElement run = scope; run != null; run = run.getNextSibling()) {
            class CancelException
            extends RuntimeException {
                CancelException() {
                }
            }
            try {
                run.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        if (name.equals(variable.getName())) {
                            throw new CancelException();
                        }
                    }
                });
                continue;
            }
            catch (CancelException e) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasConflictingVariable(@Nullable PsiElement place, @NotNull String name, boolean allowShadowing) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "hasConflictingVariable"));
        }
        if (place == null) {
            return false;
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
        PsiVariable existingVariable = helper.resolveAccessibleReferencedVariable(name, place);
        if (existingVariable == null) {
            return false;
        }
        return !allowShadowing || !(existingVariable instanceof PsiField) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiMethod.class}) == null;
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNameInfo", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        String[] names = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names.length);
        for (String name : names) {
            String withShadowing;
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual((String)(placeName = ((PsiNamedElement)place).getName()), (String)name)) {
                uniqueNames.add(name);
                continue;
            }
            String unique = this.suggestUniqueVariableName(name, place, lookForward);
            if (!unique.equals(name) && (withShadowing = JavaCodeStyleManagerImpl.suggestUniqueVariableName(name, place, lookForward, true)).equals(name)) {
                uniqueNames.add(name);
            }
            uniqueNames.add(unique);
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray(uniqueNames)){

            public void nameChosen(String name) {
                baseNameInfo.nameChosen(name);
            }
        };
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        return suggestedNameInfo;
    }

    private static void sortVariableNameSuggestions(@NotNull String[] names, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "sortVariableNameSuggestions"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "sortVariableNameSuggestions"));
        }
        if (names.length <= 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorting names:" + variableKind);
            if (propertyName != null) {
                LOG.debug("propertyName:" + propertyName);
            }
            if (type != null) {
                LOG.debug("type:" + type);
            }
            for (String name : names) {
                int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                LOG.debug(name + " : " + count);
            }
        }
        Comparator comparator2 = (s1, s2) -> {
            if (variableKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "lambda$sortVariableNameSuggestions$2"));
            }
            int count1 = JavaStatisticsManager.getVariableNameUseCount((String)s1, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            int count2 = JavaStatisticsManager.getVariableNameUseCount((String)s2, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            return count2 - count1;
        };
        Arrays.sort(names, comparator2);
    }

    @NotNull
    public String getPrefixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getPrefixByVariableKind"));
        }
        String prefix = "";
        switch (variableKind) {
            case FIELD: {
                prefix = this.getSettings().FIELD_NAME_PREFIX;
                break;
            }
            case STATIC_FIELD: {
                prefix = this.getSettings().STATIC_FIELD_NAME_PREFIX;
                break;
            }
            case PARAMETER: {
                prefix = this.getSettings().PARAMETER_NAME_PREFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                prefix = this.getSettings().LOCAL_VARIABLE_NAME_PREFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                prefix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        String string = prefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getPrefixByVariableKind"));
        }
        return string;
    }

    @NotNull
    public String getSuffixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuffixByVariableKind"));
        }
        String suffix = "";
        switch (variableKind) {
            case FIELD: {
                suffix = this.getSettings().FIELD_NAME_SUFFIX;
                break;
            }
            case STATIC_FIELD: {
                suffix = this.getSettings().STATIC_FIELD_NAME_SUFFIX;
                break;
            }
            case PARAMETER: {
                suffix = this.getSettings().PARAMETER_NAME_SUFFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                suffix = this.getSettings().LOCAL_VARIABLE_NAME_SUFFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                suffix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (suffix == null) {
            suffix = "";
        }
        String string = suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuffixByVariableKind"));
        }
        return string;
    }

    @Nullable
    private CodeStyleSettings.TypeToNameMap getMapByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getMapByVariableKind"));
        }
        if (variableKind == VariableKind.FIELD) {
            return this.getSettings().FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.STATIC_FIELD) {
            return this.getSettings().STATIC_FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.PARAMETER) {
            return this.getSettings().PARAMETER_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.LOCAL_VARIABLE) {
            return this.getSettings().LOCAL_VARIABLE_TYPE_TO_NAME;
        }
        return null;
    }

    @NonNls
    @NotNull
    private String changeIfNotIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "changeIfNotIdentifier"));
        }
        if (!this.isIdentifier(name)) {
            String string = StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "changeIfNotIdentifier"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "changeIfNotIdentifier"));
        }
        return string;
    }

    private boolean isIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "isIdentifier"));
        }
        return PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name, LanguageLevel.HIGHEST);
    }

    @NotNull
    private CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSettings"));
        }
        return codeStyleSettings;
    }

    private static boolean isStringPsiLiteral(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "isStringPsiLiteral"));
        }
        if (element instanceof PsiLiteralExpression) {
            String text = element.getText();
            return StringUtil.isQuotedString((String)text);
        }
        return false;
    }

    private static class NamesByExprInfo {
        private final String[] names;
        private final String propertyName;

        private NamesByExprInfo(String propertyName, String ... names) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl$NamesByExprInfo", "<init>"));
            }
            this.names = names;
            this.propertyName = propertyName;
        }
    }
}

