/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleFacadeImpl
extends CodeStyleFacade {
    private final Project myProject;

    public CodeStyleFacadeImpl() {
        this(null);
    }

    public CodeStyleFacadeImpl(Project project2) {
        this.myProject = project2;
    }

    public int getIndentSize(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentSize(fileType);
    }

    @Deprecated
    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/CodeStyleFacadeImpl", "getLineIndent"));
        }
        if (this.myProject == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        return CodeStyleManager.getInstance((Project)this.myProject).getLineIndent(document, offset);
    }

    public String getLineIndent(@NotNull Editor editor, @Nullable Language language, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeStyleFacadeImpl", "getLineIndent"));
        }
        if (this.myProject == null) {
            return null;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)language);
        return lineIndentProvider != null ? lineIndentProvider.getLineIndent(this.myProject, editor, language, offset) : null;
    }

    public String getLineSeparator() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getLineSeparator();
    }

    public boolean projectUsesOwnSettings() {
        return this.myProject != null && CodeStyleSettingsManager.getInstance((Project)this.myProject).USE_PER_PROJECT_SETTINGS;
    }

    public boolean isUnsuitableCodeStyleConfigurable(Configurable c) {
        return false;
    }

    public int getRightMargin(Language language) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getRightMargin(language);
    }

    @Deprecated
    public boolean isWrapWhenTypingReachesRightMargin() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    public boolean isWrapOnTyping(@Nullable Language language) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).isWrapOnTyping(language);
    }

    public int getTabSize(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getTabSize(fileType);
    }

    public boolean isSmartTabs(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).isSmartTabs(fileType);
    }

    public boolean useTabCharacter(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).useTabCharacter(fileType);
    }
}

