/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private final Project myProject;
    private final Key<FilePointersList> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY;

    public SmartPointerManagerImpl(Project project2) {
        this.myProject = project2;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        this.POINTERS_KEY = Key.create((String)("SMART_POINTERS for " + project2));
    }

    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            FilePointersList pointers = (FilePointersList)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.removeReference(reference);
        }
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        SmartPointerManagerImpl.processQueue();
        FilePointersList pointers = this.getPointers(file2);
        if (pointers != null) {
            pointers.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

                public boolean process(SmartPsiElementPointerImpl pointer) {
                    pointer.getElementInfo().fastenBelt();
                    return true;
                }
            });
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer != null && pointer.incrementAndGetReferenceCount(1) > 0) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointerImpl;
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference data = (Reference)element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)data);
        if (cachedPointer != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range, false);
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range, boolean forInjected) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file2.isValid()) {
            LOG.error("Invalid element:" + file2);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file2, ProperTextRange.create((Segment)range), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        block4: {
            FilePointersList pointers;
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            SmartPointerElementInfo info = pointer.getElementInfo();
            if (!(info instanceof SelfElementInfo)) {
                return;
            }
            PointerReference reference = new PointerReference(pointer, containingFile, this.POINTERS_KEY);
            do {
                if ((pointers = this.getPointers(containingFile)) != null) continue;
                pointers = (FilePointersList)containingFile.putUserDataIfAbsent(this.POINTERS_KEY, (Object)new FilePointersList());
            } while (!pointers.add(reference));
            if (!((SelfElementInfo)info).hasRange()) break block4;
            pointers.markerCache.rangeChanged();
        }
    }

    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        PsiFile containingFile = pointer.getContainingFile();
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            if (containingFile == null) {
                return;
            }
            VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
            FilePointersList pointers = this.getPointers(vFile);
            PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (pointers != null && reference != null) {
                pointers.removeReference(reference);
            }
        }
    }

    @Nullable
    private FilePointersList getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return (FilePointersList)containingFile.getUserData(this.POINTERS_KEY);
    }

    @Nullable
    MarkerCache getMarkerCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        FilePointersList pointers = this.getPointers(file2);
        return pointers == null ? null : pointers.markerCache;
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        VirtualFile file2 = containingFile.getViewProvider().getVirtualFile();
        FilePointersList pointers = this.getPointers(file2);
        return pointers == null ? 0 : pointers.getSize();
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        FilePointersList list;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        FilePointersList filePointersList = list = file2 == null ? null : this.getPointers(file2);
        if (list == null) {
            return;
        }
        list.markerCache.updateMarkers(frozen, events);
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTargetsAfterReparse"));
        }
        FilePointersList list = this.getPointers(file2);
        if (list == null) {
            return;
        }
        list.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

            public boolean process(SmartPsiElementPointerImpl pointer) {
                if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                    SmartPointerManagerImpl.updatePointerTarget(pointer, pointer.getPsiRange());
                }
                return true;
            }
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        pointer.cacheElement(pointer.doRestoreElement());
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }

    static {
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                SmartPointerManagerImpl.processQueue();
            }
        }, (Disposable)ApplicationManager.getApplication());
        CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");
    }

    static class FilePointersList {
        private int nextAvailableIndex;
        private int size;
        private PointerReference[] references = new PointerReference[10];
        private final MarkerCache markerCache = new MarkerCache(this);
        private boolean mySorted;

        FilePointersList() {
        }

        private synchronized boolean add(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "add"));
            }
            if (!this.isActual(reference.file, (Key<FilePointersList>)reference.key)) {
                return false;
            }
            if (this.needsExpansion() || this.isTooSparse()) {
                this.resize();
                assert (this.isActual(reference.file, (Key<FilePointersList>)reference.key));
            }
            assert (this.references[this.nextAvailableIndex] == null) : this.references[this.nextAvailableIndex];
            FilePointersList.storePointerReference(this.references, this.nextAvailableIndex++, reference);
            ++this.size;
            this.mySorted = false;
            return true;
        }

        private boolean isActual(VirtualFile file2, Key<FilePointersList> key2) {
            return file2.getUserData(key2) == this;
        }

        private boolean needsExpansion() {
            return this.nextAvailableIndex >= this.references.length;
        }

        private boolean isTooSparse() {
            return this.nextAvailableIndex > this.size * 2;
        }

        private void resize() {
            PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
            int index = 0;
            for (PointerReference ref : this.references) {
                if (ref == null) continue;
                FilePointersList.storePointerReference(newReferences, index++, ref);
            }
            assert (index == this.size) : index + " != " + this.size;
            this.references = newReferences;
            this.nextAvailableIndex = index;
        }

        private synchronized void removeReference(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "removeReference"));
            }
            int index = reference.index;
            if (index < 0) {
                return;
            }
            assert (this.isActual(reference.file, (Key<FilePointersList>)reference.key));
            assert (this.references[index] == reference) : "At " + index + " expected " + reference + ", found " + this.references[index];
            this.references[index].index = -1;
            this.references[index] = null;
            if (--this.size == 0) {
                reference.file.replace(reference.key, (Object)this, null);
            }
        }

        synchronized boolean processAlivePointers(@NotNull Processor<SmartPsiElementPointerImpl> processor2) {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "processAlivePointers"));
            }
            for (int i2 = 0; i2 < this.nextAvailableIndex; ++i2) {
                PointerReference ref = this.references[i2];
                if (ref == null) continue;
                assert (this.isActual(ref.file, (Key<FilePointersList>)ref.key));
                SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
                if (pointer == null) {
                    this.removeReference(ref);
                    continue;
                }
                if (processor2.process((Object)pointer)) continue;
                return false;
            }
            return true;
        }

        private void ensureSorted() {
            if (!this.mySorted) {
                ArrayList pointers = new ArrayList();
                this.processAlivePointers((Processor<SmartPsiElementPointerImpl>)new CommonProcessors.CollectProcessor(pointers));
                assert (this.size == pointers.size());
                Collections.sort(pointers, new Comparator<SmartPsiElementPointerImpl>(){

                    @Override
                    public int compare(SmartPsiElementPointerImpl p1, SmartPsiElementPointerImpl p2) {
                        return MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo());
                    }
                });
                for (int i2 = 0; i2 < pointers.size(); ++i2) {
                    FilePointersList.storePointerReference(this.references, i2, ((SmartPsiElementPointerImpl)pointers.get((int)i2)).pointerReference);
                }
                Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
                this.nextAvailableIndex = pointers.size();
                this.mySorted = true;
            }
        }

        private static void storePointerReference(PointerReference[] references, int index, PointerReference ref) {
            references[index] = ref;
            ref.index = index;
        }

        synchronized List<SelfElementInfo> getSortedInfos() {
            this.ensureSorted();
            final ArrayList infos = ContainerUtil.newArrayListWithCapacity((int)this.size);
            this.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

                public boolean process(SmartPsiElementPointerImpl pointer) {
                    SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
                    if (!info.hasRange()) {
                        return false;
                    }
                    infos.add(info);
                    return true;
                }
            });
            return infos;
        }

        synchronized int getSize() {
            return this.size;
        }

        synchronized void markUnsorted() {
            this.mySorted = false;
        }
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<FilePointersList> key;
        private int index;

        private PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Key<FilePointersList> key2) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            super(pointer, ourQueue);
            this.index = -2;
            this.file = containingFile;
            this.key = key2;
            pointer.pointerReference = this;
        }
    }
}

