/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowSearchUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.ThrowSearchUtil");

    private ThrowSearchUtil() {
    }

    private static boolean processExn(@NotNull PsiParameter aCatch, @NotNull Processor<UsageInfo> processor2, @NotNull Root root) {
        if (aCatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aCatch", "com/intellij/psi/impl/search/ThrowSearchUtil", "processExn"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ThrowSearchUtil", "processExn"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil", "processExn"));
        }
        PsiType type = aCatch.getType();
        if (type.isAssignableFrom(root.myType)) {
            processor2.process((Object)new UsageInfo((PsiElement)aCatch));
            return false;
        }
        if (!root.isExact && root.myType.isAssignableFrom(type)) {
            processor2.process((Object)new UsageInfo((PsiElement)aCatch));
            return true;
        }
        return true;
    }

    private static boolean scanCatches(@NotNull PsiElement elem, @NotNull Processor<UsageInfo> processor2, @NotNull Root root, @NotNull FindUsagesOptions options, @NotNull Set<PsiMethod> processed2) {
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (processed2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        while (elem != null) {
            PsiTryStatement tryStmt;
            PsiElement parent = elem.getParent();
            if (elem instanceof PsiMethod) {
                PsiMethod method2;
                PsiMethod deepestSuperMethod = ((PsiMethod)elem).findDeepestSuperMethod();
                PsiMethod psiMethod = method2 = deepestSuperMethod != null ? deepestSuperMethod : (PsiMethod)elem;
                if (!processed2.contains(method2)) {
                    processed2.add(method2);
                    PsiReference[] refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method2, (SearchScope)options.searchScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
                    for (int i2 = 0; i2 != refs.length; ++i2) {
                        if (ThrowSearchUtil.scanCatches(refs[i2].getElement(), processor2, root, options, processed2)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (elem instanceof PsiTryStatement) {
                PsiTryStatement aTry = (PsiTryStatement)elem;
                PsiParameter[] catches = aTry.getCatchBlockParameters();
                for (int i3 = 0; i3 != catches.length; ++i3) {
                    if (ThrowSearchUtil.processExn(catches[i3], processor2, root)) continue;
                    return false;
                }
            } else if (parent instanceof PsiTryStatement && elem != (tryStmt = (PsiTryStatement)parent).getTryBlock()) {
                elem = parent.getParent();
                continue;
            }
            elem = parent;
        }
        return true;
    }

    public static boolean addThrowUsages(@NotNull Processor<UsageInfo> processor2, @NotNull Root root, @NotNull FindUsagesOptions options) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ThrowSearchUtil", "addThrowUsages"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil", "addThrowUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/ThrowSearchUtil", "addThrowUsages"));
        }
        HashSet processed2 = new HashSet();
        return ThrowSearchUtil.scanCatches(root.myElement, processor2, root, options, (Set<PsiMethod>)processed2);
    }

    private static boolean isExactExnType(PsiExpression exn) {
        return exn instanceof PsiNewExpression;
    }

    @Nullable
    public static Root[] getSearchRoots(PsiElement element) {
        PsiElement parent;
        PsiKeyword kwd;
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)element;
            PsiExpression exn = aThrow.getException();
            return new Root[]{new Root(aThrow.getParent(), exn.getType(), ThrowSearchUtil.isExactExnType(exn))};
        }
        if (element instanceof PsiKeyword && "throws".equals((kwd = (PsiKeyword)element).getText()) && (parent = kwd.getParent()) != null && parent.getParent() instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)parent.getParent();
            PsiReferenceList throwsList = method2.getThrowsList();
            PsiClassType[] exns = throwsList.getReferencedTypes();
            Root[] roots = new Root[exns.length];
            for (int i2 = 0; i2 != roots.length; ++i2) {
                PsiClassType exn = exns[i2];
                roots[i2] = new Root((PsiElement)method2, (PsiType)exn, false);
            }
            return roots;
        }
        return null;
    }

    public static boolean isSearchable(PsiElement element) {
        return ThrowSearchUtil.getSearchRoots(element) != null;
    }

    public static String getSearchableTypeName(PsiElement e) {
        if (e instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)e;
            PsiType type = aThrow.getException().getType();
            return PsiFormatUtil.formatType((PsiType)type, (int)8192, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (e instanceof PsiKeyword && "throws".equals(e.getText())) {
            return e.getParent().getText();
        }
        LOG.error("invalid searchable element");
        return e.getText();
    }

    public static class Root {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final PsiType myType;
        private final boolean isExact;

        public Root(@NotNull PsiElement root, @NotNull PsiType type, boolean exact) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil$Root", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/search/ThrowSearchUtil$Root", "<init>"));
            }
            this.myElement = root;
            this.myType = type;
            this.isExact = exact;
        }

        public String toString() {
            return PsiFormatUtil.formatType((PsiType)this.myType, (int)8192, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
    }
}

