/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FormatterTestCase
extends LightPlatformTestCase {
    protected boolean doReformatRangeTest;
    protected TextRange myTextRange;
    protected EditorImpl myEditor;
    protected PsiFile myFile;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FormatterTestCase.assertFalse((boolean)CodeStyleSettingsManager.getInstance((Project)FormatterTestCase.getProject()).USE_PER_PROJECT_SETTINGS);
        FormatterTestCase.assertNull((Object)CodeStyleSettingsManager.getInstance((Project)FormatterTestCase.getProject()).PER_PROJECT_SETTINGS);
    }

    protected void doTest(String resultNumber) throws Exception {
        this.doTestForResult(this.getTestName(true), resultNumber);
    }

    protected void doTest() throws Exception {
        this.doTest(null);
    }

    private void doTestForResult(String testName, String resultNumber) throws Exception {
        this.doTest(testName + "." + this.getFileExtension(), testName + "_after." + this.getFileExtension(), resultNumber);
    }

    protected void doTest(String fileNameBefore, String fileNameAfter, String resultNumber) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore, null), this.loadFile(fileNameAfter, resultNumber));
    }

    protected final void doTest(@NonNls String fileNameBefore, @NonNls String fileNameAfter) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore + "." + this.getFileExtension(), null), this.loadFile(fileNameAfter + "." + this.getFileExtension(), null));
    }

    protected void doTextTest(@NonNls String text, @NonNls String textAfter) throws IncorrectOperationException {
        this.doTextTest(text, textAfter, CheckPolicy.BOTH);
    }

    protected void doTextTest(String text, String textAfter, @NotNull CheckPolicy checkPolicy) throws IncorrectOperationException {
        if (checkPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkPolicy", "com/intellij/psi/formatter/FormatterTestCase", "doTextTest"));
        }
        String fileName = "before." + this.getFileExtension();
        PsiFile file2 = this.createFileFromText(text, fileName, PsiFileFactory.getInstance((Project)FormatterTestCase.getProject()));
        if (checkPolicy.isCheckDocument()) {
            this.checkDocument(file2, text, textAfter);
        }
        if (checkPolicy.isCheckPsi()) {
            // empty if block
        }
    }

    protected PsiFile createFileFromText(String text, String fileName, PsiFileFactory fileFactory) {
        return fileFactory.createFileFromText(fileName, this.getFileType(fileName), (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
    }

    protected FileType getFileType(String fileName) {
        return FileTypeManager.getInstance().getFileTypeByFileName(fileName);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myFile != null) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)FormatterTestCase.getProject())).clearUndoRedoQueueInTests(this.myFile.getVirtualFile());
                FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).closeFile(this.myFile.getVirtualFile());
            }
        }
        finally {
            this.myEditor = null;
            this.myFile = null;
            super.tearDown();
        }
    }

    private void restoreFileContent(PsiFile file2, String text) {
        CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).getDocument(file2);
            document.replaceString(0, document.getTextLength(), (CharSequence)text);
            PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
        }), "test", null);
    }

    protected boolean doCheckDocumentUpdate() {
        return false;
    }

    protected void checkDocument(PsiFile file2, String text, String textAfter) {
        Document document = PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).getDocument(file2);
        if (this.doCheckDocumentUpdate()) {
            EditorImpl editor = (EditorImpl)FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).openTextEditor(new OpenFileDescriptor(FormatterTestCase.getProject(), file2.getVirtualFile(), 0), false);
            editor.putUserData(EditorImpl.DO_DOCUMENT_UPDATE_TEST, Boolean.TRUE);
            if (this.myFile != null) {
                FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).closeFile(this.myFile.getVirtualFile());
            }
            this.myEditor = editor;
            this.myFile = file2;
        } else {
            Object editor = null;
        }
        WriteCommandAction.runWriteCommandAction((Project)FormatterTestCase.getProject(), () -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)text);
            PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
            FormatterTestCase.assertEquals((String)file2.getText(), (String)document.getText());
            try {
                if (this.doReformatRangeTest) {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatRange((PsiElement)file2, file2.getTextRange().getStartOffset(), file2.getTextRange().getEndOffset());
                } else if (this.myTextRange != null) {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file2, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
                } else {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file2, file2.getTextRange().getStartOffset(), file2.getTextRange().getEndOffset());
                }
            }
            catch (IncorrectOperationException e) {
                FormatterTestCase.fail();
            }
        });
        FormatterTestCase.assertEquals((String)textAfter, (String)document.getText());
        PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
        FormatterTestCase.assertEquals((String)textAfter, (String)file2.getText());
    }

    private void checkPsi(PsiFile file2, String textAfter) {
        CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.performFormatting(file2)), "", (Object)"");
        String fileText = file2.getText();
        FormatterTestCase.assertEquals((String)textAfter, (String)fileText);
    }

    protected void performFormatting(PsiFile file2) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformat((PsiElement)file2);
            } else {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatRange((PsiElement)file2, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            FormatterTestCase.fail();
        }
    }

    protected void performFormattingWithDocument(PsiFile file2) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file2, 0, file2.getTextLength());
            } else {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file2, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            FormatterTestCase.fail();
        }
    }

    protected String loadFile(String name, String resultNumber) throws Exception {
        String fullName = this.getTestDataPath() + File.separatorChar + this.getBasePath() + File.separatorChar + name;
        String text = FileUtil.loadFile((File)new File(fullName));
        text = StringUtil.convertLineSeparators((String)text);
        if (resultNumber == null) {
            return this.prepareText(text);
        }
        String beginLine = "<<<" + resultNumber + ">>>";
        String endLine = "<<</" + resultNumber + ">>>";
        int beginPos = text.indexOf(beginLine);
        FormatterTestCase.assertTrue((beginPos >= 0 ? 1 : 0) != 0);
        int endPos = text.indexOf(endLine);
        FormatterTestCase.assertTrue((endPos >= 0 ? 1 : 0) != 0);
        return this.prepareText(text.substring(beginPos + beginLine.length(), endPos).trim());
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected String prepareText(String text) {
        return text;
    }

    protected abstract String getBasePath();

    protected abstract String getFileExtension();

    protected void defaultSettings() {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)FormatterTestCase.getProject());
        settings.ALIGN_MULTILINE_PARAMETERS = true;
        settings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
        settings.ALIGN_MULTILINE_FOR = true;
        settings.ALIGN_MULTILINE_BINARY_OPERATION = false;
        settings.ALIGN_MULTILINE_TERNARY_OPERATION = false;
        settings.ALIGN_MULTILINE_THROWS_LIST = false;
        settings.ALIGN_MULTILINE_EXTENDS_LIST = false;
        settings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
        settings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
        this.getSettings().SPACE_BEFORE_ANOTATION_PARAMETER_LIST = false;
        this.getSettings().SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        this.getSettings().SPACE_WITHIN_ANNOTATION_PARENTHESES = false;
        this.getSettings().SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
    }

    protected static CommonCodeStyleSettings getSettings(Language language) {
        return CodeStyleSettingsManager.getSettings((Project)FormatterTestCase.getProject()).getCommonSettings(language);
    }

    protected CodeStyleSettings getSettings() {
        return CodeStyleSettingsManager.getSettings((Project)FormatterTestCase.getProject());
    }

    protected void doSanityTestForDirectory(File directory, boolean formatWithPsi) throws IOException, IncorrectOperationException {
        ArrayList<File> failedFiles = new ArrayList<File>();
        this.doSanityTestForDirectory(directory, failedFiles, formatWithPsi);
        if (!failedFiles.isEmpty()) {
            FormatterTestCase.fail((String)("Failed for files: " + this.composeMessage(failedFiles)));
        }
    }

    private void doSanityTestForDirectory(File directory, List<File> failedFiles, boolean formatWithPsi) throws IOException, IncorrectOperationException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file2 : files) {
                this.doSanityTestForFile(file2, failedFiles, formatWithPsi);
                this.doSanityTestForDirectory(file2, failedFiles, formatWithPsi);
            }
        }
    }

    protected void doSanityTest(boolean formatWithPsi) throws IOException, IncorrectOperationException {
        File sanityDirectory = new File(this.getTestDataPath() + File.separatorChar + this.getBasePath(), "sanity");
        File[] subFiles = sanityDirectory.listFiles();
        ArrayList<File> failedFiles = new ArrayList<File>();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                this.doSanityTestForFile(subFile, failedFiles, formatWithPsi);
            }
            if (!failedFiles.isEmpty()) {
                FormatterTestCase.fail((String)("Failed for files: " + this.composeMessage(failedFiles)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSanityTestForFile(File subFile, List<File> failedFiles, boolean formatWithPsi) throws IOException, IncorrectOperationException {
        if (subFile.isFile() && subFile.getName().endsWith(this.getFileExtension())) {
            byte[] bytes = FileUtil.loadFileBytes((File)subFile);
            String text = new String(bytes);
            String fileName = "before." + this.getFileExtension();
            PsiFile file2 = PsiFileFactory.getInstance((Project)FormatterTestCase.getProject()).createFileFromText(fileName, this.getFileType(fileName), (CharSequence)StringUtil.convertLineSeparators((String)text), LocalTimeCounter.currentTime(), true);
            try {
                CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        if (formatWithPsi) {
                            this.performFormatting(file2);
                        } else {
                            this.performFormattingWithDocument(file2);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        failedFiles.add(subFile);
                    }
                    System.out.println(subFile.getPath() + ": finished");
                }), "", null);
            }
            finally {
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile != null) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)FormatterTestCase.getProject())).clearUndoRedoQueueInTests(virtualFile);
                    ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearUndoRedoQueueInTests(virtualFile);
                }
            }
        }
    }

    private String composeMessage(List<File> failedFiles) {
        StringBuffer result2 = new StringBuffer();
        for (File file2 : failedFiles) {
            result2.append(file2.getPath());
            result2.append("\n");
        }
        return result2.toString();
    }

    static enum CheckPolicy {
        PSI(true, false),
        DOCUMENT(false, true),
        BOTH(true, true);

        private final boolean myCheckPsi;
        private final boolean myCheckDocument;

        private CheckPolicy(boolean checkPsi, boolean checkDocument) {
            this.myCheckDocument = checkDocument;
            this.myCheckPsi = checkPsi;
        }

        public boolean isCheckPsi() {
            return this.myCheckPsi;
        }

        public boolean isCheckDocument() {
            return this.myCheckDocument;
        }
    }
}

