/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.FilterUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public class AssignableFromFilter
implements ElementFilter {
    private PsiType myType;
    private String myClassName;

    public AssignableFromFilter(PsiType type) {
        this.myType = type;
    }

    public AssignableFromFilter(String className) {
        this.myClassName = className;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        Object type = this.myType;
        if (type == null) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
            PsiClass aClass = psiFacade.findClass(this.myClassName, context.getResolveScope());
            type = aClass != null ? psiFacade.getElementFactory().createType(aClass, PsiSubstitutor.EMPTY) : null;
        }
        if (type == null) {
            return false;
        }
        if (element == null) {
            return false;
        }
        if (element instanceof PsiType) {
            return type.isAssignableFrom((PsiType)element);
        }
        PsiSubstitutor substitutor = null;
        if (element instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)element;
            substitutor = info.getSubstitutor();
            element = info.getElement();
        }
        return AssignableFromFilter.isAcceptable((PsiElement)element, context, type, substitutor);
    }

    public static boolean isAcceptable(PsiElement element, PsiElement context, PsiType expectedType, PsiSubstitutor substitutor) {
        if (element instanceof PsiMethod && AssignableFromFilter.isReturnTypeInferrable((PsiMethod)element, context, expectedType, substitutor)) {
            return true;
        }
        PsiType typeByElement = FilterUtil.getTypeByElement(element, context);
        if (typeByElement == null) {
            return false;
        }
        if (substitutor != null) {
            typeByElement = substitutor.substitute(typeByElement);
        }
        if (!AssignableFromFilter.allowBoxing(context) && expectedType instanceof PsiPrimitiveType != typeByElement instanceof PsiPrimitiveType) {
            return false;
        }
        return expectedType.isAssignableFrom(typeByElement);
    }

    private static boolean allowBoxing(PsiElement place) {
        PsiSynchronizedStatement statement2;
        PsiElement parent = place.getParent();
        return !(parent.getParent() instanceof PsiSynchronizedStatement) || !parent.equals((statement2 = (PsiSynchronizedStatement)parent.getParent()).getLockExpression());
    }

    private static boolean isReturnTypeInferrable(PsiMethod method2, PsiElement place, PsiType expectedType, @Nullable PsiSubstitutor substitutor) {
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method2.getProject()).getResolveHelper();
        for (PsiTypeParameter parameter : method2.getTypeParameters()) {
            PsiType substitutionForParameter;
            PsiType returnType = method2.getReturnType();
            if (substitutor != null) {
                returnType = substitutor.substitute(returnType);
            }
            if ((substitutionForParameter = helper.getSubstitutionForTypeParameter(parameter, returnType, expectedType, false, PsiUtil.getLanguageLevel((PsiElement)place))) == PsiType.NULL || substitutionForParameter instanceof PsiIntersectionType || PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutionForParameter) == parameter) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "assignable-from(" + (this.myType != null ? this.myType : this.myClassName) + ")";
    }
}

