/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ControlFlowImpl
implements ControlFlow {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ControlFlowImpl");
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final ObjectIntHashMap<PsiElement> myElementToStartOffsetMap = new ObjectIntHashMap();
    private final ObjectIntHashMap<PsiElement> myElementToEndOffsetMap = new ObjectIntHashMap();
    private final List<PsiElement> myElementsForInstructions = new ArrayList<PsiElement>();
    private boolean myConstantConditionOccurred;
    private final Stack<PsiElement> myElementStack = new Stack();

    ControlFlowImpl() {
    }

    void addInstruction(Instruction instruction) {
        this.myInstructions.add(instruction);
        this.myElementsForInstructions.add((PsiElement)this.myElementStack.peek());
    }

    public void startElement(PsiElement element) {
        this.myElementStack.push((Object)element);
        this.myElementToStartOffsetMap.put((Object)element, this.myInstructions.size());
    }

    void finishElement(PsiElement element) {
        PsiElement popped = (PsiElement)this.myElementStack.pop();
        LOG.assertTrue(popped.equals(element));
        this.myElementToEndOffsetMap.put((Object)element, this.myInstructions.size());
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        List<Instruction> list = this.myInstructions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowImpl", "getInstructions"));
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.myInstructions.size();
    }

    @Override
    public int getStartOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowImpl", "getStartOffset"));
        }
        return this.myElementToStartOffsetMap.get((Object)element, -1);
    }

    @Override
    public int getEndOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowImpl", "getEndOffset"));
        }
        return this.myElementToEndOffsetMap.get((Object)element, -1);
    }

    @Override
    public PsiElement getElement(int offset) {
        return this.myElementsForInstructions.get(offset);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myConstantConditionOccurred;
    }

    void setConstantConditionOccurred(boolean constantConditionOccurred) {
        this.myConstantConditionOccurred = constantConditionOccurred;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < this.myInstructions.size(); ++i2) {
            Instruction instruction = this.myInstructions.get(i2);
            buffer.append(Integer.toString(i2));
            buffer.append(": ");
            buffer.append(instruction);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

