/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectedIndentOptionsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"indent.options.notification.provider");
    private static final Key<Boolean> NOTIFIED_FLAG = Key.create((String)"indent.options.notification.provider.status");
    protected static final Key<Boolean> DETECT_INDENT_NOTIFICATION_SHOWN_KEY = Key.create((String)"indent.options.notification.provider.status.test.notification.shown");
    private static boolean myShowNotificationInTest = false;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key2 = KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "getKey"));
        }
        return key2;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        Editor editor;
        Project project2;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        Boolean notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG);
        if (fileEditor instanceof TextEditor && notifiedFlag != null && (project2 = (editor = ((TextEditor)fileEditor).getEditor()).getProject()) != null) {
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            PsiFile psiFile = documentManager.getPsiFile(document);
            Ref indentOptionsProviderRef = new Ref();
            if (psiFile != null) {
                EditorNotificationInfo info;
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2);
                CommonCodeStyleSettings.IndentOptions userOptions = settings.getIndentOptions(psiFile.getFileType());
                CommonCodeStyleSettings.IndentOptions detectedOptions = CodeStyleSettingsManager.getSettings((Project)project2).getIndentOptionsByFile(psiFile, null, false, provider -> {
                    indentOptionsProviderRef.set(provider);
                    return false;
                });
                FileIndentOptionsProvider provider2 = (FileIndentOptionsProvider)indentOptionsProviderRef.get();
                EditorNotificationInfo editorNotificationInfo = info = provider2 != null && !provider2.isAcceptedWithoutWarning(project2, file2) && !userOptions.equals((Object)detectedOptions) ? provider2.getNotificationInfo(project2, file2, fileEditor, userOptions, detectedOptions) : null;
                if (info != null) {
                    EditorNotificationPanel panel2 = new EditorNotificationPanel().text(info.getTitle());
                    if (info.getIcon() != null) {
                        panel2.icon(info.getIcon());
                    }
                    for (EditorNotificationInfo.ActionLabelData actionLabelData : info.getLabelAndActions()) {
                        Runnable onClickAction = () -> {
                            actionLabelData.action.run();
                            EditorNotifications.getInstance((Project)project2).updateAllNotifications();
                        };
                        panel2.createActionLabel(actionLabelData.label, onClickAction);
                    }
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        file2.putUserData(DETECT_INDENT_NOTIFICATION_SHOWN_KEY, (Object)Boolean.TRUE);
                    }
                    return panel2;
                }
            }
        }
        return null;
    }

    public static void updateIndentNotification(@NotNull PsiFile file2, boolean enforce) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "updateIndentNotification"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode() && myShowNotificationInTest) {
            Boolean notifiedFlag;
            Project project2 = file2.getProject();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            if (fileEditorManager == null) {
                return;
            }
            FileEditor fileEditor = fileEditorManager.getSelectedEditor(vFile);
            if (fileEditor != null && ((notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG)) == null || enforce)) {
                fileEditor.putUserData(NOTIFIED_FLAG, (Object)Boolean.TRUE);
                EditorNotifications.getInstance((Project)project2).updateNotifications(vFile);
            }
        }
    }

    static void setShowNotificationInTest(boolean show) {
        myShowNotificationInTest = show;
    }
}

