/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeepTrailingSpacesOnEmptyLinesFilterFactory
extends StripTrailingSpacesFilterFactory {
    @NotNull
    public StripTrailingSpacesFilter createFilter(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory", "createFilter"));
        }
        if (project2 != null && KeepTrailingSpacesOnEmptyLinesFilterFactory.shouldKeepTrailingSpacesOnEmptyLines(project2, document)) {
            KeepTrailingSpacesOnEmptyLinesFilter keepTrailingSpacesOnEmptyLinesFilter = new KeepTrailingSpacesOnEmptyLinesFilter(document);
            if (keepTrailingSpacesOnEmptyLinesFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory", "createFilter"));
            }
            return keepTrailingSpacesOnEmptyLinesFilter;
        }
        StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.ALL_LINES;
        if (stripTrailingSpacesFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory", "createFilter"));
        }
        return stripTrailingSpacesFilter;
    }

    private static boolean shouldKeepTrailingSpacesOnEmptyLines(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory", "shouldKeepTrailingSpacesOnEmptyLines"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory", "shouldKeepTrailingSpacesOnEmptyLines"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(document);
        if (file2 != null) {
            CommonCodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings(file2.getLanguage());
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
            return indentOptions != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
        }
        return false;
    }

    private static class KeepTrailingSpacesOnEmptyLinesFilter
    implements StripTrailingSpacesFilter {
        @NotNull
        private Document myDocument;

        public KeepTrailingSpacesOnEmptyLinesFilter(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory$KeepTrailingSpacesOnEmptyLinesFilter", "<init>"));
            }
            this.myDocument = document;
        }

        public boolean isStripSpacesAllowedForLine(int line) {
            int startOffset = this.myDocument.getLineStartOffset(line);
            int endOffset = this.myDocument.getLineEndOffset(line);
            return !KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(this.myDocument.getCharsSequence(), startOffset, endOffset);
        }

        private static boolean containsWhitespacesOnly(@NotNull CharSequence chars, int start, int end) {
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory$KeepTrailingSpacesOnEmptyLinesFilter", "containsWhitespacesOnly"));
            }
            for (int i2 = start; i2 < end; ++i2) {
                char c = chars.charAt(i2);
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                return false;
            }
            return true;
        }
    }
}

