/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilesComboBox
extends ComboBox<InspectionProfileImpl> {
    private static final String PROJECT_LEVEL_SEPARATOR_TEXT = "Project Level";
    private static final String GLOBAL_LEVEL_SEPARATOR_TEXT = "Global Level";
    private SortedComboBoxModel<InspectionProfileImpl> myComboModel;
    private InspectionProfileImpl myFirstGlobalProfile;

    public ProfilesComboBox() {
        Comparator<InspectionProfileImpl> comparator2 = Comparator.comparing(NewInspectionProfile::isProjectLevel).reversed().thenComparing(InspectionProfileImpl::getDisplayName);
        this.myComboModel = new SortedComboBoxModel(comparator2);
        this.setModel((ComboBoxModel)this.myComboModel);
        this.setRenderer(new ListCellRenderer<InspectionProfileImpl>(){
            ListCellRendererWrapper<InspectionProfileImpl> baseRenderer = new ListCellRendererWrapper<InspectionProfileImpl>(){

                public void customize(JList list, InspectionProfileImpl value, int index, boolean selected, boolean hasFocus) {
                    if (index == -1) {
                        this.setIcon(value.isProjectLevel() ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                    }
                    this.setText(value.getDisplayName());
                }
            };

            @Override
            public Component getListCellRendererComponent(JList list, InspectionProfileImpl o, int index, boolean isSelected, boolean cellHasFocus) {
                TitledSeparator separator = null;
                if (index != -1) {
                    if (!o.isProjectLevel()) {
                        if (o == ProfilesComboBox.this.myFirstGlobalProfile) {
                            separator = new TitledSeparator(ProfilesComboBox.GLOBAL_LEVEL_SEPARATOR_TEXT);
                        }
                    } else if (o == ProfilesComboBox.this.myComboModel.get(0)) {
                        separator = new TitledSeparator(ProfilesComboBox.PROJECT_LEVEL_SEPARATOR_TEXT);
                    }
                }
                Component renderedComponent = this.baseRenderer.getListCellRendererComponent(list, (Object)o, index, isSelected, cellHasFocus);
                if (separator == null) {
                    return renderedComponent;
                }
                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)separator.getLabel());
                separator.getLabel().setIcon(separator.getText().equals(ProfilesComboBox.PROJECT_LEVEL_SEPARATOR_TEXT) ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                separator.setBackground(renderedComponent.getBackground());
                separator.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)0, (int)2));
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)separator, "North");
                p.add(renderedComponent, "Center");
                p.setBackground(renderedComponent.getBackground());
                return p;
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl profile = ProfilesComboBox.this.getSelectedProfile();
                if (profile != null) {
                    ProfilesComboBox.this.onProfileChosen(profile);
                }
            }
        });
    }

    protected abstract void onProfileChosen(InspectionProfileImpl var1);

    public void selectProfile(InspectionProfileImpl inspectionProfile) {
        this.setSelectedItem(inspectionProfile);
    }

    public void reset(Collection<InspectionProfileImpl> profiles) {
        this.myComboModel.clear();
        for (InspectionProfileImpl profile : profiles) {
            this.myComboModel.add((Object)profile);
        }
        this.findFirstGlobalProfile();
        this.setSelectedIndex(0);
        this.resort();
    }

    void removeProfile(InspectionProfileImpl profile) {
        this.myComboModel.remove((Object)profile);
        if (!profile.isProjectLevel() && profile == this.myFirstGlobalProfile) {
            this.findFirstGlobalProfile();
        }
    }

    public void addProfile(InspectionProfileImpl inspectionProfile) {
        this.myComboModel.add((Object)inspectionProfile);
        if (!inspectionProfile.isProjectLevel()) {
            this.findFirstGlobalProfile();
        }
    }

    InspectionProfileImpl getSelectedProfile() {
        return (InspectionProfileImpl)this.myComboModel.getSelectedItem();
    }

    @NotNull
    List<InspectionProfileImpl> getProfiles() {
        List list = this.myComboModel.getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/ProfilesComboBox", "getProfiles"));
        }
        return list;
    }

    private void findFirstGlobalProfile() {
        this.myFirstGlobalProfile = null;
        for (InspectionProfileImpl profile : this.getProfiles()) {
            if (profile.isProjectLevel()) continue;
            this.myFirstGlobalProfile = profile;
            break;
        }
    }

    public void resort() {
        this.myComboModel.setAll((Collection)this.myComboModel.getItems());
        this.findFirstGlobalProfile();
    }
}

