/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010 J\u0018\u0010\u001f\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020 J\u0006\u0010\"\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u0010J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020 H\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/profile/codeInspection/BaseInspectionProfileManager;", "Lcom/intellij/profile/codeInspection/InspectionProjectProfileManager;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lcom/intellij/util/messages/MessageBus;)V", "profileListeners", "", "Lcom/intellij/profile/ProfileChangeAdapter;", "getProfileListeners", "()Ljava/util/List;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "addProfile", "", "profile", "addProfileChangeListener", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "cleanupSchemes", "project", "Lcom/intellij/openapi/project/Project;", "cleanupSchemes$analysis_impl", "deleteProfile", "name", "", "fireProfileChanged", "Lcom/intellij/codeInspection/InspectionProfile;", "oldProfile", "getOwnSeverityRegistrar", "getSeverityRegistrar", "schemeRemoved", "scheme", "updateProfile", "analysis-impl"})
public abstract class BaseInspectionProfileManager
extends InspectionProjectProfileManager {
    @NotNull
    private final List<ProfileChangeAdapter> profileListeners;
    private final SeverityRegistrar severityRegistrar;

    @NotNull
    protected abstract SchemeManager<InspectionProfileImpl> getSchemeManager();

    @NotNull
    protected final List<ProfileChangeAdapter> getProfileListeners() {
        return this.profileListeners;
    }

    @Override
    @NotNull
    public final SeverityRegistrar getSeverityRegistrar() {
        return this.severityRegistrar;
    }

    @Override
    @NotNull
    public final SeverityRegistrar getOwnSeverityRegistrar() {
        return this.severityRegistrar;
    }

    @Override
    public final void addProfileChangeListener(@NotNull ProfileChangeAdapter listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        ContainerUtil.add((Object)listener2, (Collection)this.profileListeners, (Disposable)parentDisposable);
    }

    public final void cleanupSchemes$analysis_impl(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        for (InspectionProfileImpl profile : this.getSchemeManager().getAllSchemes()) {
            profile.cleanup(project2);
        }
    }

    @Override
    public final void fireProfileChanged(@Nullable InspectionProfile profile) {
        if (profile instanceof InspectionProfileImpl) {
            ((InspectionProfileImpl)profile).profileChanged();
        }
        for (ProfileChangeAdapter adapter : this.profileListeners) {
            adapter.profileChanged(profile);
        }
    }

    @Override
    public final void fireProfileChanged(@Nullable InspectionProfile oldProfile, @NotNull InspectionProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        for (ProfileChangeAdapter adapter : this.profileListeners) {
            adapter.profileActivated(oldProfile, profile);
        }
    }

    public final void addProfile(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.getSchemeManager().addScheme((InspectionProfileImpl)((Scheme)profile));
    }

    public final void deleteProfile(@NotNull String name) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            InspectionProfileImpl inspectionProfileImpl = this.getSchemeManager().removeScheme(name);
            if (inspectionProfileImpl == null) break block0;
            InspectionProfileImpl inspectionProfileImpl2 = inspectionProfileImpl;
            InspectionProfileImpl it = inspectionProfileImpl2;
            InspectionProfile inspectionProfile = (InspectionProfile)it;
            Intrinsics.checkExpressionValueIsNotNull((Object)inspectionProfile, (String)"it");
            this.schemeRemoved(inspectionProfile);
        }
    }

    public final void deleteProfile(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.getSchemeManager().removeScheme((InspectionProfileImpl)((Scheme)profile));
        this.schemeRemoved((InspectionProfile)profile);
    }

    protected void schemeRemoved(@NotNull InspectionProfile scheme2) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
    }

    public void updateProfile(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.getSchemeManager().addScheme((InspectionProfileImpl)((Scheme)profile));
        this.fireProfileChanged((InspectionProfile)profile);
    }

    public BaseInspectionProfileManager(@NotNull MessageBus messageBus) {
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLock\u2026t<ProfileChangeAdapter>()");
        this.profileListeners = list;
        this.severityRegistrar = new SeverityRegistrar(messageBus);
    }
}

