/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactElementType
extends ComplexPackagingElementType<ArtifactPackagingElement> {
    public static final ArtifactElementType ARTIFACT_ELEMENT_TYPE = new ArtifactElementType();

    ArtifactElementType() {
        super("artifact", CompilerBundle.message((String)"element.type.name.artifact", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/ArtifactElementType", "canCreate"));
        }
        return !ArtifactElementType.getAvailableArtifacts(context, artifact, false).isEmpty();
    }

    @NotNull
    public List<? extends ArtifactPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/ArtifactElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/ArtifactElementType", "chooseAndCreate"));
        }
        Project project2 = context.getProject();
        List artifacts = context.chooseArtifacts(ArtifactElementType.getAvailableArtifacts(context, artifact, false), CompilerBundle.message((String)"dialog.title.choose.artifacts", (Object[])new Object[0]));
        ArrayList<ArtifactPackagingElement> elements = new ArrayList<ArtifactPackagingElement>();
        for (Artifact selected : artifacts) {
            elements.add(new ArtifactPackagingElement(project2, ArtifactPointerManager.getInstance((Project)project2).createPointer(selected, context.getArtifactModel())));
        }
        ArrayList<ArtifactPackagingElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ArtifactElementType", "chooseAndCreate"));
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends Artifact> getAvailableArtifacts(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, boolean notIncludedOnly) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactElementType", "getAvailableArtifacts"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/ArtifactElementType", "getAvailableArtifacts"));
        }
        HashSet<Artifact> result2 = new HashSet<Artifact>(Arrays.asList(context.getArtifactModel().getArtifacts()));
        if (notIncludedOnly) {
            ArtifactUtil.processPackagingElements(artifact, ARTIFACT_ELEMENT_TYPE, artifactPackagingElement -> {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactElementType", "lambda$getAvailableArtifacts$0"));
                }
                result2.remove(artifactPackagingElement.findArtifact((PackagingElementResolvingContext)context));
                return true;
            }, (PackagingElementResolvingContext)context, true);
        }
        result2.remove(artifact);
        Iterator iterator = result2.iterator();
        while (iterator.hasNext()) {
            Artifact another = (Artifact)iterator.next();
            boolean notContainThis = ArtifactUtil.processPackagingElements(another, ARTIFACT_ELEMENT_TYPE, element -> {
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/ArtifactElementType", "lambda$getAvailableArtifacts$1"));
                }
                return !artifact.getName().equals(element.getArtifactName());
            }, (PackagingElementResolvingContext)context, true);
            if (notContainThis) continue;
            iterator.remove();
        }
        ArrayList<Artifact> list = new ArrayList<Artifact>(result2);
        Collections.sort(list, ArtifactManager.ARTIFACT_COMPARATOR);
        ArrayList<Artifact> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ArtifactElementType", "getAvailableArtifacts"));
        }
        return arrayList;
    }

    @NotNull
    public ArtifactPackagingElement createEmpty(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ArtifactElementType", "createEmpty"));
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2);
        if (artifactPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ArtifactElementType", "createEmpty"));
        }
        return artifactPackagingElement;
    }

    public String getShowContentActionText() {
        return "Show Content of Included Artifacts";
    }
}

