/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedContentTabLabel
extends ContentTabLabel {
    private final ComboIcon myComboIcon = new ComboIcon(){

        @Override
        public Rectangle getIconRec() {
            return new Rectangle(TabbedContentTabLabel.this.getWidth() - this.getIconWidth() - 3, 0, this.getIconWidth(), TabbedContentTabLabel.this.getHeight());
        }

        @Override
        public boolean isActive() {
            return true;
        }
    };
    private final TabbedContent myContent;
    @Nullable
    private Reference<JBPopup> myPopupReference = null;

    public TabbedContentTabLabel(TabbedContent content, TabContentLayout layout) {
        super((Content)content, layout);
        this.myContent = content;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$2", "onClick"));
                }
                TabbedContentTabLabel.this.showPopup();
                return true;
            }
        }.installOn((Component)this);
    }

    private void showPopup() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        ArrayList<Object> names = new ArrayList<Object>();
        for (Pair tab : this.myContent.getTabs()) {
            names.add(tab.first);
        }
        JBList list = new JBList(names);
        list.installCellRenderer((NotNullFunction)new NotNullFunction<Object, JComponent>(){
            private final JLabel label = new JLabel();
            {
                this.label.setBorder(new EmptyBorder(UIUtil.getListCellPadding()));
            }

            @NotNull
            public JComponent fun(Object dom) {
                String tabName = dom.toString();
                this.label.setText(tabName);
                TabbedContentTabLabel.this.setIconInPopupLabel(this.label, tabName);
                JLabel jLabel = this.label;
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$3", "fun"));
                }
                return jLabel;
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(() -> {
            int index = list.getSelectedIndex();
            if (index != -1) {
                this.myContent.selectContent(index);
            }
        }).createPopup();
        this.myPopupReference = new WeakReference<JBPopup>(popup);
        popup.showUnderneathOf((Component)this);
    }

    private void setIconInPopupLabel(JLabel label, String tabName) {
        Icon baseIcon = this.getBaseIcon();
        boolean hasIconsInTabs = baseIcon != null;
        for (Pair nextTabWithName : this.myContent.getTabs()) {
            if (!((String)nextTabWithName.getFirst()).equals(tabName)) continue;
            JComponent tab = (JComponent)nextTabWithName.getSecond();
            Icon tabIcon = null;
            if (tab instanceof Iconable) {
                tabIcon = ((Iconable)tab).getIcon(1);
                if (hasIconsInTabs && tabIcon == null) {
                    tabIcon = EmptyIcon.create((Icon)baseIcon);
                }
            }
            label.setIcon(tabIcon);
        }
    }

    @Nullable
    private Icon getBaseIcon() {
        Icon baseIcon = null;
        for (Pair nextTabWithName : this.myContent.getTabs()) {
            Icon tabIcon;
            JComponent tabComponent = (JComponent)nextTabWithName.getSecond();
            if (!(tabComponent instanceof Iconable) || (tabIcon = ((Iconable)tabComponent).getIcon(1)) == null) continue;
            baseIcon = tabIcon;
            break;
        }
        return baseIcon;
    }

    @Override
    public void update() {
        super.update();
        if (this.myContent != null) {
            String tabName = this.myContent.getTabName();
            this.setText(tabName);
            this.setTabIcon(tabName, this);
        }
        this.setHorizontalAlignment(2);
    }

    private void setTabIcon(String tabName, JLabel jLabel) {
        for (Pair nextTabWithName : this.myContent.getTabs()) {
            JComponent tab;
            if (tabName == null || !((String)nextTabWithName.getFirst()).equals(ContentUtilEx.getTabNameWithoutPrefix(this.myContent, tabName)) || !((tab = (JComponent)nextTabWithName.getSecond()) instanceof Iconable)) continue;
            Icon baseIcon = ((Iconable)tab).getIcon(1);
            jLabel.setIcon(this.isSelected() || baseIcon == null ? baseIcon : new WatermarkIcon(baseIcon, 0.5f));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width + 12, size.height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myComboIcon.paintIcon(this, g);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JBPopup popup = (JBPopup)SoftReference.dereference(this.myPopupReference);
        if (popup != null) {
            Disposer.dispose((Disposable)popup);
            this.myPopupReference = null;
        }
    }
}

