/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import java.lang.ref.WeakReference;
import java.util.Arrays;

class MapReference
extends WeakReference<KeyFMap> {
    final int myHash;

    MapReference(KeyFMap referent) {
        super(referent);
        this.myHash = MapReference.computeHashCode(referent);
    }

    private static int computeHashCode(KeyFMap object) {
        if (object instanceof OneElementFMap) {
            return ((OneElementFMap)object).getKey().hashCode() * 31 + System.identityHashCode(((OneElementFMap)object).getValue());
        }
        if (object instanceof PairElementsFMap) {
            PairElementsFMap map = (PairElementsFMap)object;
            return (map.getKey1().hashCode() * 31 + map.getKey2().hashCode()) * 31 + System.identityHashCode(map.getValue1()) + System.identityHashCode(map.getValue2());
        }
        if (object instanceof ArrayBackedFMap) {
            int hc = Arrays.hashCode(((ArrayBackedFMap)object).getKeyIds());
            for (Object o : ((ArrayBackedFMap)object).getValues()) {
                hc = hc * 31 + System.identityHashCode(o);
            }
            return hc;
        }
        return 0;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MapReference) || this.myHash != ((MapReference)obj).myHash) {
            return false;
        }
        KeyFMap o1 = (KeyFMap)this.get();
        KeyFMap o2 = (KeyFMap)((MapReference)obj).get();
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof OneElementFMap && o2 instanceof OneElementFMap) {
            OneElementFMap m1 = (OneElementFMap)o1;
            OneElementFMap m2 = (OneElementFMap)o2;
            return m1.getKey() == m2.getKey() && m1.getValue() == m2.getValue();
        }
        if (o1 instanceof PairElementsFMap && o2 instanceof PairElementsFMap) {
            PairElementsFMap m1 = (PairElementsFMap)o1;
            PairElementsFMap m2 = (PairElementsFMap)o2;
            return m1.getKey1() == m2.getKey1() && m1.getKey2() == m2.getKey2() && m1.getValue1() == m2.getValue1() && m1.getValue2() == m2.getValue2();
        }
        if (o1 instanceof ArrayBackedFMap && o2 instanceof ArrayBackedFMap) {
            ArrayBackedFMap m1 = (ArrayBackedFMap)o1;
            ArrayBackedFMap m2 = (ArrayBackedFMap)o2;
            return Arrays.equals(m1.getKeyIds(), m2.getKeyIds()) && MapReference.containSameElements(m1.getValues(), m2.getValues());
        }
        return false;
    }

    private static boolean containSameElements(Object[] v1, Object[] v2) {
        if (v1.length != v2.length) {
            return false;
        }
        for (int i2 = 0; i2 < v1.length; ++i2) {
            if (v1[i2] == v2[i2]) continue;
            return false;
        }
        return true;
    }
}

