/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class JrtHandler
extends ArchiveHandler {
    private static final URI ROOT_URI = URI.create("jrt:/");
    private SoftReference<FileSystem> myFileSystem;

    public JrtHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "<init>"));
        }
        super(path);
    }

    private synchronized FileSystem getFileSystem() throws IOException {
        FileSystem fs = (FileSystem)SoftReference.dereference(this.myFileSystem);
        if (fs == null) {
            String path = this.getFile().getPath();
            try {
                if (SystemInfo.isJavaVersionAtLeast((String)"9")) {
                    fs = FileSystems.newFileSystem(ROOT_URI, Collections.singletonMap("java.home", path));
                } else {
                    File file2 = new File(path, "lib/jrt-fs.jar");
                    if (!file2.exists()) {
                        file2 = new File(path, "jrt-fs.jar");
                    }
                    if (!file2.exists()) {
                        throw new IOException("Missing provider: " + file2);
                    }
                    URL url = file2.toURI().toURL();
                    URLClassLoader loader = new URLClassLoader(new URL[]{url}, null);
                    fs = FileSystems.newFileSystem(ROOT_URI, Collections.emptyMap(), (ClassLoader)loader);
                }
                this.myFileSystem = new SoftReference((Object)fs);
            }
            catch (Error | RuntimeException e) {
                throw new IOException("Error mounting JRT filesystem at " + path, e);
            }
        }
        return fs;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        final HashMap map = ContainerUtil.newHashMap();
        map.put("", this.createRootEntry());
        Path root = this.getFileSystem().getPath("/modules", new String[0]);
        if (!Files.exists(root, new LinkOption[0])) {
            throw new FileNotFoundException("JRT root missing");
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.process(dir, attrs);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                this.process(file2, attrs);
                return FileVisitResult.CONTINUE;
            }

            private void process(Path entry, BasicFileAttributes attrs) throws IOException {
                Path relativePath;
                String path;
                int pathLength = entry.getNameCount();
                if (pathLength > 1 && !map.containsKey(path = (relativePath = entry.subpath(1, pathLength)).toString())) {
                    ArchiveHandler.EntryInfo parent = (ArchiveHandler.EntryInfo)map.get(pathLength > 2 ? relativePath.getParent().toString() : "");
                    if (parent == null) {
                        throw new IOException("Out of order: " + entry);
                    }
                    String shortName = entry.getFileName().toString();
                    long modified = attrs.lastModifiedTime().toMillis();
                    map.put(path, new ArchiveHandler.EntryInfo((CharSequence)shortName, attrs.isDirectory(), attrs.size(), modified, parent));
                }
            }
        });
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "createEntriesMap"));
        }
        return hashMap;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
        }
        ArchiveHandler.EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null) {
            throw new FileNotFoundException(this.getFile() + " : " + relativePath);
        }
        Path path = this.getFileSystem().getPath("/modules/" + relativePath, new String[0]);
        byte[] byArray = Files.readAllBytes(path);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
        }
        return byArray;
    }
}

