/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class VcsInitialization
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsInitialization");
    private final List<Pair<VcsInitObject, Runnable>> myList;
    private final Object myLock;
    @NotNull
    private final Project myProject;
    private boolean myInitStarted;
    private volatile Future<?> myFuture;
    private final ProgressIndicator myIndicator;

    public VcsInitialization(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization", "<init>"));
        }
        this.myList = new ArrayList<Pair<VcsInitObject, Runnable>>();
        this.myIndicator = new StandardProgressIndicatorBase();
        this.myProject = project2;
        this.myLock = new Object();
        StartupManager.getInstance((Project)project2).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization", "lambda$new$0"));
            }
            if (project2.isDisposed()) {
                return;
            }
            this.myFuture = ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, "VCS Initialization"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/VcsInitialization$1", "run"));
                    }
                    VcsInitialization.this.execute();
                }
            }, this.myIndicator, null);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable2) {
        if (vcsInitObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsInitObject", "com/intellij/openapi/vcs/impl/VcsInitialization", "add"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/impl/VcsInitialization", "add"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInitStarted) {
                if (!vcsInitObject.isCanBeLast()) {
                    LOG.info("Registering startup activity AFTER initialization ", new Throwable());
                }
                ApplicationManager.getApplication().invokeLater(runnable2);
                return;
            }
            this.myList.add((Pair<VcsInitObject, Runnable>)Pair.create((Object)((Object)vcsInitObject), (Object)runnable2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        List<Pair<VcsInitObject, Runnable>> list;
        Iterator<Pair<VcsInitObject, Runnable>> iterator = this.myLock;
        synchronized (iterator) {
            list = this.myList;
            this.myInitStarted = true;
            Future<?> future2 = this.myFuture;
            if (future2 != null && future2.isCancelled() || ProgressManager.getGlobalProgressIndicator().isCanceled()) {
                return;
            }
        }
        Collections.sort(list, (o1, o2) -> ((VcsInitObject)((Object)((Object)o1.getFirst()))).getOrder() - ((VcsInitObject)((Object)((Object)o2.getFirst()))).getOrder());
        for (Pair<VcsInitObject, Runnable> pair : list) {
            ProgressManager.checkCanceled();
            ((Runnable)pair.getSecond()).run();
        }
    }

    void waitForInitialized() {
        try {
            this.myFuture.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        this.myIndicator.cancel();
        this.cancelBackgroundInitialization();
    }

    private void cancelBackgroundInitialization() {
        Future<?> future2 = this.myFuture;
        if (future2 != null) {
            future2.cancel(false);
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                SwingUtilities.invokeLater(this::waitForCompletion);
            } else {
                this.waitForCompletion();
            }
        }
    }

    private void waitForCompletion() {
        long start = System.currentTimeMillis();
        while (this.myIndicator.isRunning() && System.currentTimeMillis() < start + 10000L) {
            TimeoutUtil.sleep((long)10L);
        }
        if (this.myIndicator.isRunning()) {
            LOG.error("Failed to wait for completion if VCS initialization for project " + this.myProject, new Attachment[]{new Attachment("thread dump", ThreadDumper.dumpThreadsToString())});
        }
    }
}

