/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.configurable.VcsCheckBoxWithSpinnerConfigurable;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;

public class VcsLimitHistoryConfigurable
extends VcsCheckBoxWithSpinnerConfigurable {
    private final VcsConfiguration myConfiguration;

    public VcsLimitHistoryConfigurable(Project project2) {
        super(project2, "Limit history to: ", "rows");
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
    }

    @Override
    protected SpinnerNumberModel createSpinnerModel() {
        int rows = this.myConfiguration.MAXIMUM_HISTORY_ROWS;
        return new SpinnerNumberModel(rows, 10, 1000000, 10);
    }

    @Nls
    public String getDisplayName() {
        return "Limit History";
    }

    public boolean isModified() {
        if (this.myHighlightRecentlyChanged.isSelected() != this.myConfiguration.LIMIT_HISTORY) {
            return true;
        }
        return !Comparing.equal((Object)this.myHighlightInterval.getValue(), (Object)this.myConfiguration.MAXIMUM_HISTORY_ROWS);
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.LIMIT_HISTORY = this.myHighlightRecentlyChanged.isSelected();
        this.myConfiguration.MAXIMUM_HISTORY_ROWS = ((Number)this.myHighlightInterval.getValue()).intValue();
    }

    public void reset() {
        this.myHighlightRecentlyChanged.setSelected(this.myConfiguration.LIMIT_HISTORY);
        this.myHighlightInterval.setValue(this.myConfiguration.MAXIMUM_HISTORY_ROWS);
        this.myHighlightInterval.setEnabled(this.myHighlightRecentlyChanged.isSelected());
    }
}

