/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackWorker {
    private final Project myProject;
    private final String myOperationName;
    private final boolean myInvokedFromModalContext;
    private final List<VcsException> myExceptions;

    public RollbackWorker(Project project2) {
        this(project2, DefaultRollbackEnvironment.ROLLBACK_OPERATION_NAME, false);
    }

    public RollbackWorker(Project project2, String operationName, boolean invokedFromModalContext) {
        this.myProject = project2;
        this.myOperationName = operationName;
        this.myInvokedFromModalContext = invokedFromModalContext;
        this.myExceptions = new ArrayList<VcsException>(0);
    }

    public void doRollback(Collection<Change> changes, boolean deleteLocallyAddedFiles, final @Nullable Runnable afterVcsRefreshInAwt, @Nullable String localHistoryActionName) {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        final Runnable notifier = changeListManager.prepareForChangeDeletion(changes);
        Runnable afterRefresh = new Runnable(){

            @Override
            public void run() {
                InvokeAfterUpdateMode updateMode = RollbackWorker.this.myInvokedFromModalContext ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.SILENT;
                changeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        notifier.run();
                        if (afterVcsRefreshInAwt != null) {
                            afterVcsRefreshInAwt.run();
                        }
                    }
                }, updateMode, "Refresh changelists after update", ModalityState.current());
            }
        };
        final MyRollbackRunnable rollbackAction = new MyRollbackRunnable(changes, deleteLocallyAddedFiles, afterRefresh, localHistoryActionName);
        if (ApplicationManager.getApplication().isDispatchThread() && !this.myInvokedFromModalContext) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myOperationName, true, new PerformInBackgroundOption(){

                public boolean shouldStartInBackground() {
                    return VcsConfiguration.getInstance((Project)((RollbackWorker)RollbackWorker.this).myProject).PERFORM_ROLLBACK_IN_BACKGROUND;
                }

                public void processSentToBackground() {
                    VcsConfiguration.getInstance((Project)((RollbackWorker)RollbackWorker.this).myProject).PERFORM_ROLLBACK_IN_BACKGROUND = true;
                }
            }){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$3", "run"));
                    }
                    rollbackAction.run();
                }
            });
        } else if (this.myInvokedFromModalContext) {
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, this.myOperationName, true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$4", "run"));
                    }
                    DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)rollbackAction);
                }
            });
        } else {
            rollbackAction.run();
        }
        ((ChangeListManagerImpl)changeListManager).showLocalChangesInvalidated();
    }

    private class MyRollbackRunnable
    implements Runnable {
        private final Collection<Change> myChanges;
        private final boolean myDeleteLocallyAddedFiles;
        private final Runnable myAfterRefresh;
        private final String myLocalHistoryActionName;
        private ProgressIndicator myIndicator;

        private MyRollbackRunnable(Collection<Change> changes, boolean deleteLocallyAddedFiles, Runnable afterRefresh, String localHistoryActionName) {
            this.myChanges = changes;
            this.myDeleteLocallyAddedFiles = deleteLocallyAddedFiles;
            this.myAfterRefresh = afterRefresh;
            this.myLocalHistoryActionName = localHistoryActionName;
        }

        @Override
        public void run() {
            ChangesUtil.markInternalOperation(this.myChanges, (boolean)true);
            try {
                this.doRun();
            }
            finally {
                ChangesUtil.markInternalOperation(this.myChanges, (boolean)false);
            }
        }

        private void doRun() {
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            ArrayList<Change> changesToRefresh = new ArrayList<Change>();
            try {
                ChangesUtil.processChangesByVcs((Project)RollbackWorker.this.myProject, this.myChanges, (vcs, changes) -> {
                    RollbackEnvironment environment = vcs.getRollbackEnvironment();
                    if (environment != null) {
                        changesToRefresh.addAll(changes);
                        if (this.myIndicator != null) {
                            this.myIndicator.setText(vcs.getDisplayName() + ": performing " + StringUtil.toLowerCase((String)RollbackWorker.this.myOperationName) + "...");
                            this.myIndicator.setIndeterminate(false);
                            this.myIndicator.checkCanceled();
                        }
                        environment.rollbackChanges(changes, RollbackWorker.this.myExceptions, (RollbackProgressListener)new RollbackProgressModifier(changes.size(), this.myIndicator));
                        if (this.myIndicator != null) {
                            this.myIndicator.setText2("");
                            this.myIndicator.checkCanceled();
                        }
                        if (RollbackWorker.this.myExceptions.isEmpty() && this.myDeleteLocallyAddedFiles) {
                            this.deleteAddedFilesLocally(changes);
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (this.myIndicator != null) {
                this.myIndicator.startNonCancelableSection();
                this.myIndicator.setIndeterminate(true);
                this.myIndicator.setText2("");
                this.myIndicator.setText(VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
            }
            this.doRefresh(RollbackWorker.this.myProject, changesToRefresh);
            AbstractVcsHelper.getInstance((Project)RollbackWorker.this.myProject).showErrors(RollbackWorker.this.myExceptions, RollbackWorker.this.myOperationName);
        }

        private void doRefresh(final Project project2, final List<Change> changesToRefresh) {
            final LocalHistoryAction action = LocalHistory.getInstance().startAction(RollbackWorker.this.myOperationName);
            Runnable forAwtThread = new Runnable(){

                @Override
                public void run() {
                    action.finish();
                    LocalHistory.getInstance().putSystemLabel(RollbackWorker.this.myProject, MyRollbackRunnable.this.myLocalHistoryActionName == null ? RollbackWorker.this.myOperationName : MyRollbackRunnable.this.myLocalHistoryActionName, -1);
                    VcsDirtyScopeManager manager = (VcsDirtyScopeManager)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, VcsDirtyScopeManager.class);
                    VcsGuess vcsGuess = new VcsGuess(RollbackWorker.this.myProject);
                    for (Change change : changesToRefresh) {
                        ContentRevision beforeRevision = change.getBeforeRevision();
                        ContentRevision afterRevision = change.getAfterRevision();
                        if (!change.isIsReplaced() && beforeRevision != null && Comparing.equal((Object)beforeRevision, (Object)afterRevision)) {
                            manager.fileDirty(beforeRevision.getFile());
                            continue;
                        }
                        MyRollbackRunnable.this.markDirty(manager, vcsGuess, beforeRevision);
                        MyRollbackRunnable.this.markDirty(manager, vcsGuess, afterRevision);
                    }
                    MyRollbackRunnable.this.myAfterRefresh.run();
                }
            };
            RefreshVFsSynchronously.updateChangesForRollback(changesToRefresh);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)forAwtThread, null, (Project)project2);
        }

        private void markDirty(@NotNull VcsDirtyScopeManager manager, @NotNull VcsGuess vcsGuess, @Nullable ContentRevision revision) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$MyRollbackRunnable", "markDirty"));
            }
            if (vcsGuess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsGuess", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$MyRollbackRunnable", "markDirty"));
            }
            if (revision != null) {
                FilePath parent = revision.getFile().getParentPath();
                if (parent != null && this.couldBeMarkedDirty(vcsGuess, parent)) {
                    manager.dirDirtyRecursively(parent);
                } else {
                    manager.fileDirty(revision.getFile());
                }
            }
        }

        private boolean couldBeMarkedDirty(@NotNull VcsGuess vcsGuess, @NotNull FilePath path) {
            if (vcsGuess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsGuess", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$MyRollbackRunnable", "couldBeMarkedDirty"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$MyRollbackRunnable", "couldBeMarkedDirty"));
            }
            return vcsGuess.getVcsForDirty(path) != null;
        }

        private void deleteAddedFilesLocally(List<Change> changes) {
            if (this.myIndicator != null) {
                this.myIndicator.setText("Deleting added files locally...");
                this.myIndicator.setFraction(0.0);
            }
            int changesSize = changes.size();
            for (int i2 = 0; i2 < changesSize; ++i2) {
                Change c = changes.get(i2);
                if (c.getType() != Change.Type.NEW) continue;
                ContentRevision rev = c.getAfterRevision();
                assert (rev != null);
                File ioFile = rev.getFile().getIOFile();
                if (this.myIndicator != null) {
                    this.myIndicator.setText2(ioFile.getAbsolutePath());
                    this.myIndicator.setFraction((double)i2 / (double)changesSize);
                }
                FileUtil.delete((File)ioFile);
            }
            if (this.myIndicator != null) {
                this.myIndicator.setText2("");
            }
        }
    }
}

